/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segment
extends PolyLine {
    private static final Logger logger = LoggerFactory.getLogger(Segment.class);
    private static final long serialVersionUID = -5796676985841139897L;

    public static List<Location> asList(Iterable<Segment> segments) {
        ArrayList<Location> result = new ArrayList<Location>();
        Iterables.stream(segments).forEach(segment -> {
            if (result.isEmpty() || !((Location)result.get(result.size() - 1)).equals(segment.start())) {
                result.add(segment.start());
            }
            result.add(segment.end());
        });
        return result;
    }

    private static List<Location> asList(Location start, Location end) {
        ArrayList<Location> result = new ArrayList<Location>();
        result.add(start);
        result.add(end);
        return result;
    }

    public Segment(Location start, Location end) {
        super(Segment.asList(start, end));
    }

    public Location end() {
        return this.last();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Segment) {
            Segment that = (Segment)other;
            return this.start().equals(that.start()) && this.end().equals(that.end());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end() == null ? 0 : this.end().hashCode());
        result = 31 * result + (this.start() == null ? 0 : this.start().hashCode());
        return result;
    }

    public Optional<Heading> heading() {
        if (this.isPoint()) {
            logger.warn("Cannot compute a segment's heading when the segment is a point with same start and end {}", (Object)this.start());
            return Optional.empty();
        }
        return Optional.of(this.start().headingTo(this.end()));
    }

    public Location intersection(Segment that) {
        double p0X = this.start().getLongitude().asDegrees();
        double p0Y = this.start().getLatitude().asDegrees();
        double p1X = this.end().getLongitude().asDegrees();
        double p1Y = this.end().getLatitude().asDegrees();
        double p2X = that.start().getLongitude().asDegrees();
        double p2Y = that.start().getLatitude().asDegrees();
        double p3X = that.end().getLongitude().asDegrees();
        double p3Y = that.end().getLatitude().asDegrees();
        double s1X = p1X - p0X;
        double s1Y = p1Y - p0Y;
        double s2X = p3X - p2X;
        double s2Y = p3Y - p2Y;
        double sValue = (-s1Y * (p0X - p2X) + s1X * (p0Y - p2Y)) / (-s2X * s1Y + s1X * s2Y);
        double tValue = (s2X * (p0Y - p2Y) - s2Y * (p0X - p2X)) / (-s2X * s1Y + s1X * s2Y);
        if (sValue >= 0.0 && sValue <= 1.0 && tValue >= 0.0 && tValue <= 1.0) {
            return new Location(Latitude.degrees(p0Y + tValue * s1Y), Longitude.degrees(p0X + tValue * s1X));
        }
        return null;
    }

    public boolean intersects(Segment that) {
        long xAxis1 = this.start().getLongitude().asDm7();
        long yAxis1 = this.start().getLatitude().asDm7();
        long xAxis2 = this.end().getLongitude().asDm7();
        long yAxis2 = this.end().getLatitude().asDm7();
        long xAxis3 = that.start().getLongitude().asDm7();
        long yAxis3 = that.start().getLatitude().asDm7();
        long xAxis4 = that.end().getLongitude().asDm7();
        long yAxis4 = that.end().getLatitude().asDm7();
        if (xAxis1 == xAxis2 && yAxis1 == yAxis2 || xAxis3 == xAxis4 && yAxis3 == yAxis4) {
            return false;
        }
        long axAxis = xAxis2 - xAxis1;
        long ayAxis = yAxis2 - yAxis1;
        long bxAxis = xAxis3 - xAxis4;
        long byAxis = yAxis3 - yAxis4;
        long cxAxis = xAxis1 - xAxis3;
        long cyAxis = yAxis1 - yAxis3;
        try {
            long alphaNumerator = Math.subtractExact(byAxis * cxAxis, bxAxis * cyAxis);
            long commonDenominator = Math.subtractExact(ayAxis * bxAxis, axAxis * byAxis);
            if (commonDenominator > 0L && (alphaNumerator < 0L || alphaNumerator > commonDenominator) || commonDenominator < 0L && (alphaNumerator > 0L || alphaNumerator < commonDenominator)) {
                return false;
            }
            long betaNumerator = Math.subtractExact(axAxis * cyAxis, ayAxis * cxAxis);
            if (commonDenominator > 0L && (betaNumerator < 0L || betaNumerator > commonDenominator) || commonDenominator < 0L && (betaNumerator > 0L || betaNumerator < commonDenominator)) {
                return false;
            }
            if (commonDenominator == 0L) {
                long collinearityTestForP3 = xAxis1 * (yAxis2 - yAxis3) + xAxis2 * (yAxis3 - yAxis1) + xAxis3 * (yAxis1 - yAxis2);
                return collinearityTestForP3 == 0L && (xAxis1 >= xAxis3 && xAxis1 <= xAxis4 || xAxis1 <= xAxis3 && xAxis1 >= xAxis4 || xAxis2 >= xAxis3 && xAxis2 <= xAxis4 || xAxis2 <= xAxis3 && xAxis2 >= xAxis4 || xAxis3 >= xAxis1 && xAxis3 <= xAxis2 || xAxis3 <= xAxis1 && xAxis3 >= xAxis2) && (yAxis1 >= yAxis3 && yAxis1 <= yAxis4 || yAxis1 <= yAxis3 && yAxis1 >= yAxis4 || yAxis2 >= yAxis3 && yAxis2 <= yAxis4 || yAxis2 <= yAxis3 && yAxis2 >= yAxis4 || yAxis3 >= yAxis1 && yAxis3 <= yAxis2 || yAxis3 <= yAxis1 && yAxis3 >= yAxis2);
            }
            return true;
        }
        catch (ArithmeticException overflow) {
            return this.intersectsApproximate(that);
        }
    }

    private boolean intersectsApproximate(Segment that) {
        double xAxis1 = this.start().getLongitude().asDegrees();
        double yAxis1 = this.start().getLatitude().asDegrees();
        double xAxis2 = this.end().getLongitude().asDegrees();
        double yAxis2 = this.end().getLatitude().asDegrees();
        double xAxis3 = that.start().getLongitude().asDegrees();
        double yAxis3 = that.start().getLatitude().asDegrees();
        double xAxis4 = that.end().getLongitude().asDegrees();
        double yAxis4 = that.end().getLatitude().asDegrees();
        if (xAxis1 == xAxis2 && yAxis1 == yAxis2 || xAxis3 == xAxis4 && yAxis3 == yAxis4) {
            return false;
        }
        double axAxis = xAxis2 - xAxis1;
        double ayAxis = yAxis2 - yAxis1;
        double bxAxis = xAxis3 - xAxis4;
        double byAxis = yAxis3 - yAxis4;
        double cxAxis = xAxis1 - xAxis3;
        double cyAxis = yAxis1 - yAxis3;
        double alphaNumerator = byAxis * cxAxis - bxAxis * cyAxis;
        double commonDenominator = ayAxis * bxAxis - axAxis * byAxis;
        if (commonDenominator > 0.0 && (alphaNumerator < 0.0 || alphaNumerator > commonDenominator) || commonDenominator < 0.0 && (alphaNumerator > 0.0 || alphaNumerator < commonDenominator)) {
            return false;
        }
        double betaNumerator = axAxis * cyAxis - ayAxis * cxAxis;
        if (commonDenominator > 0.0 && (betaNumerator < 0.0 || betaNumerator > commonDenominator) || commonDenominator < 0.0 && (betaNumerator > 0.0 || betaNumerator < commonDenominator)) {
            return false;
        }
        if (commonDenominator == 0.0) {
            double collinearityTestForP3 = xAxis1 * (yAxis2 - yAxis3) + xAxis2 * (yAxis3 - yAxis1) + xAxis3 * (yAxis1 - yAxis2);
            return collinearityTestForP3 == 0.0 && (xAxis1 >= xAxis3 && xAxis1 <= xAxis4 || xAxis1 <= xAxis3 && xAxis1 >= xAxis4 || xAxis2 >= xAxis3 && xAxis2 <= xAxis4 || xAxis2 <= xAxis3 && xAxis2 >= xAxis4 || xAxis3 >= xAxis1 && xAxis3 <= xAxis2 || xAxis3 <= xAxis1 && xAxis3 >= xAxis2) && (yAxis1 >= yAxis3 && yAxis1 <= yAxis4 || yAxis1 <= yAxis3 && yAxis1 >= yAxis4 || yAxis2 >= yAxis3 && yAxis2 <= yAxis4 || yAxis2 <= yAxis3 && yAxis2 >= yAxis4 || yAxis3 >= yAxis1 && yAxis3 <= yAxis2 || yAxis3 <= yAxis1 && yAxis3 >= yAxis2);
        }
        return true;
    }

    public boolean isEastWest() {
        return this.start().hasSameLatitudeAs(this.end());
    }

    public boolean isNorthSouth() {
        return this.start().hasSameLongitudeAs(this.end());
    }

    @Override
    public boolean isPoint() {
        return this.start().equals(this.end());
    }

    @Override
    public Distance length() {
        return this.start().distanceTo(this.end());
    }

    @Override
    public Location middle() {
        return new Location(Latitude.degrees((this.start().getLatitude().asDegrees() + this.end().getLatitude().asDegrees()) / 2.0), Longitude.degrees((this.start().getLongitude().asDegrees() + this.end().getLongitude().asDegrees()) / 2.0));
    }

    @Override
    public Location offsetFromStart(Ratio ratio) {
        Optional<Heading> heading = this.heading();
        if (heading.isPresent()) {
            return this.start().shiftAlongGreatCircle(heading.get(), this.length().scaleBy(ratio));
        }
        return this.start();
    }

    public Segment pointingNorth() {
        if (this.isEastWest()) {
            return this;
        }
        if (this.start().getLatitude().isLessThan(this.end().getLatitude())) {
            return this;
        }
        return new Segment(this.end(), this.start());
    }

    @Override
    public Segment reversed() {
        return new Segment(this.end(), this.start());
    }

    public Location start() {
        return this.first();
    }

    protected double dotProduct(Segment that) {
        double thisLatitudeSpan = this.latitudeSpan();
        double thatLatitudeSpan = that.latitudeSpan();
        double thisLongitudeSpan = this.longitudeSpan();
        double thatLongitudeSpan = that.longitudeSpan();
        return thisLatitudeSpan * thatLatitudeSpan + thisLongitudeSpan * thatLongitudeSpan;
    }

    protected double dotProductLength() {
        return Math.sqrt(this.dotProduct(this));
    }

    protected long latitudeSpan() {
        return this.end().getLatitude().asDm7() - this.start().getLatitude().asDm7();
    }

    protected long longitudeSpan() {
        return this.end().getLongitude().asDm7() - this.start().getLongitude().asDm7();
    }
}

