/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.BoundingBox;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Surface;

public final class Rectangle
extends Polygon {
    private static final long serialVersionUID = 6940095569975683891L;
    public static final Rectangle MAXIMUM = Rectangle.forCorners(new Location(Latitude.MINIMUM, Longitude.MINIMUM), new Location(Latitude.MAXIMUM, Longitude.MAXIMUM));
    public static final Rectangle MINIMUM = Rectangle.forCorners(Location.CENTER, Location.CENTER);
    public static final Rectangle TEST_RECTANGLE = Rectangle.forString("37.328167,-122.031905:37.330394,-122.029051");
    public static final Rectangle TEST_RECTANGLE_2 = Rectangle.forString("37.325194,-122.034281:37.325683,-122.033500");
    private final Location lowerLeft;
    private final Location upperRight;

    public static Rectangle forBoundingBox(BoundingBox boundingBox) {
        return Rectangle.forLocations(new Location(Latitude.degrees(boundingBox.getMinY()), Longitude.degrees(boundingBox.getMinX())), new Location(Latitude.degrees(boundingBox.getMaxY()), Longitude.degrees(boundingBox.getMaxX())));
    }

    public static Rectangle forCorners(Location lowerLeft, Location upperRight) {
        if (lowerLeft == null || upperRight == null) {
            throw new CoreException("Cannot build a Rectangle with one of the corners being null.");
        }
        if (lowerLeft.isNorthOf(upperRight)) {
            throw new CoreException("Lower left cannot be higher than upper right.");
        }
        if (lowerLeft.isEastOf(upperRight)) {
            throw new CoreException("Lower left cannot be to the right of the upper right.");
        }
        return new Rectangle(lowerLeft, upperRight);
    }

    public static <T extends Located> Rectangle forLocated(Iterable<T> locateds) {
        Latitude lower = null;
        Latitude upper = null;
        Longitude left = null;
        Longitude right = null;
        boolean hasOneItem = false;
        for (Located located : locateds) {
            hasOneItem = true;
            for (Location location : located.bounds()) {
                Latitude latitude = location.getLatitude();
                Longitude longitude = location.getLongitude();
                if (lower == null || latitude.isLessThan(lower)) {
                    lower = latitude;
                }
                if (upper == null || latitude.isGreaterThan(upper)) {
                    upper = latitude;
                }
                if (left == null || longitude.isLessThan(left)) {
                    left = longitude;
                }
                if (right != null && !longitude.isGreaterThan(right)) continue;
                right = longitude;
            }
        }
        if (!hasOneItem) {
            throw new CoreException("Rectangle.forLocated(Iterable<Located>) has to have at least one item in the Iterable<Located>");
        }
        return Rectangle.forCorners(new Location(lower, left), new Location(upper, right));
    }

    public static Rectangle forLocated(Located ... locateds) {
        return Rectangle.forLocated(Iterables.iterable(locateds));
    }

    public static Rectangle forLocations(Iterable<Location> locations) {
        Latitude lower = null;
        Latitude upper = null;
        Longitude left = null;
        Longitude right = null;
        for (Location location : locations) {
            Latitude latitude = location.getLatitude();
            Longitude longitude = location.getLongitude();
            if (lower == null || latitude.isLessThan(lower)) {
                lower = latitude;
            }
            if (upper == null || latitude.isGreaterThan(upper)) {
                upper = latitude;
            }
            if (left == null || longitude.isLessThan(left)) {
                left = longitude;
            }
            if (right != null && !longitude.isGreaterThan(right)) continue;
            right = longitude;
        }
        return Rectangle.forCorners(new Location(lower, left), new Location(upper, right));
    }

    public static Rectangle forLocations(Location ... locations) {
        return Rectangle.forLocations(Iterables.iterable(locations));
    }

    public static Rectangle forString(String rectangleString) {
        StringList split = StringList.split(rectangleString, ":");
        if (split.size() != 2) {
            throw new CoreException("Invalid Rectangle String: {}", rectangleString);
        }
        return Rectangle.forLocations(Location.forString(split.get(0)), Location.forString(split.get(1)));
    }

    private Rectangle(Location lowerLeft, Location upperRight) {
        super(lowerLeft, new Location(upperRight.getLatitude(), lowerLeft.getLongitude()), upperRight, new Location(lowerLeft.getLatitude(), upperRight.getLongitude()));
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
    }

    public Envelope asEnvelope() {
        return new Envelope(this.lowerLeft.getLongitude().asDegrees(), this.upperRight.getLongitude().asDegrees(), this.lowerLeft.getLatitude().asDegrees(), this.upperRight.getLatitude().asDegrees());
    }

    public JsonArray asGeoJsonBbox() {
        JsonArray array = new JsonArray();
        array.add(new JsonPrimitive(this.lowerLeft.getLongitude().asDegrees()));
        array.add(new JsonPrimitive(this.lowerLeft.getLatitude().asDegrees()));
        array.add(new JsonPrimitive(this.upperRight.getLongitude().asDegrees()));
        array.add(new JsonPrimitive(this.upperRight.getLatitude().asDegrees()));
        return array;
    }

    @Override
    public Rectangle bounds() {
        return this;
    }

    @Override
    public Location center() {
        return new Segment(this.lowerLeft, this.upperRight).middle();
    }

    public Rectangle combine(Rectangle that) {
        return Rectangle.forLocations(this.lowerLeft, this.upperRight, that.lowerLeft, that.upperRight);
    }

    public Rectangle contract(Distance distance) {
        Location newLowerLeft = this.lowerLeft.shiftAlongGreatCircle(Heading.NORTH, distance).shiftAlongGreatCircle(Heading.EAST, distance);
        Location newUpperRight = this.upperRight.shiftAlongGreatCircle(Heading.SOUTH, distance).shiftAlongGreatCircle(Heading.WEST, distance);
        boolean tooShortHeight = newLowerLeft.getLatitude().isGreaterThan(newUpperRight.getLatitude());
        boolean tooShortWidth = newLowerLeft.getLongitude().isGreaterThan(newUpperRight.getLongitude());
        if (tooShortHeight && tooShortWidth) {
            return this.center().bounds();
        }
        Location lowerRight = new Location(this.lowerLeft().getLatitude(), this.upperRight().getLongitude());
        if (tooShortHeight) {
            Latitude sharedLatitude = lowerRight.midPoint(this.upperRight()).getLatitude();
            return Rectangle.forCorners(new Location(sharedLatitude, newLowerLeft.getLongitude()), new Location(sharedLatitude, newUpperRight.getLongitude()));
        }
        if (tooShortWidth) {
            Longitude sharedLongitude = lowerRight.midPoint(this.lowerLeft()).getLongitude();
            return Rectangle.forCorners(new Location(newLowerLeft.getLatitude(), sharedLongitude), new Location(newUpperRight.getLatitude(), sharedLongitude));
        }
        return Rectangle.forCorners(newLowerLeft, newUpperRight);
    }

    public Rectangle expand(Distance distance) {
        Location newLowerLeft = this.lowerLeft.shiftAlongGreatCircle(Heading.SOUTH, distance).shiftAlongGreatCircle(Heading.WEST, distance);
        Location newUpperRight = this.upperRight.shiftAlongGreatCircle(Heading.NORTH, distance).shiftAlongGreatCircle(Heading.EAST, distance);
        return Rectangle.forCorners(newLowerLeft, newUpperRight);
    }

    public Rectangle expandHorizontally(Distance distance) {
        Location newLowerLeft = this.lowerLeft.shiftAlongGreatCircle(Heading.WEST, distance);
        Location newUpperRight = this.upperRight.shiftAlongGreatCircle(Heading.EAST, distance);
        return Rectangle.forCorners(newLowerLeft, newUpperRight);
    }

    public Rectangle expandVertically(Distance distance) {
        Location newLowerLeft = this.lowerLeft.shiftAlongGreatCircle(Heading.SOUTH, distance);
        Location newUpperRight = this.upperRight.shiftAlongGreatCircle(Heading.NORTH, distance);
        return Rectangle.forCorners(newLowerLeft, newUpperRight);
    }

    public boolean fullyGeometricallyEncloses(Located item) {
        Rectangle bounds = item instanceof Rectangle ? (Rectangle)item : item.bounds();
        return this.lowerLeft().getLatitude().isLessThanOrEqualTo(bounds.lowerLeft().getLatitude()) && this.lowerLeft().getLongitude().isLessThanOrEqualTo(bounds.lowerLeft().getLongitude()) && this.upperRight().getLatitude().isGreaterThanOrEqualTo(bounds.upperRight().getLatitude()) && this.upperRight().getLongitude().isGreaterThanOrEqualTo(bounds.upperRight().getLongitude());
    }

    @Override
    public boolean fullyGeometricallyEncloses(Location item) {
        return this.fullyGeometricallyEncloses((Located)item);
    }

    @Override
    public boolean fullyGeometricallyEncloses(Rectangle item) {
        return this.fullyGeometricallyEncloses((Located)item);
    }

    public Angle height() {
        return Angle.dm7(this.upperRight.getLatitude().asDm7() - this.lowerLeft.getLatitude().asDm7());
    }

    public Rectangle intersection(Rectangle other) {
        block17: {
            if (other == null) {
                return null;
            }
            if (this.equals(other)) {
                return this;
            }
            if (this.fullyGeometricallyEncloses(other)) {
                return other;
            }
            if (other.fullyGeometricallyEncloses(this)) {
                return this;
            }
            Set<Location> intersections = this.intersections(other);
            if (intersections.size() == 0) {
                return null;
            }
            if (intersections.size() == 1) {
                return Rectangle.forLocations((Iterable<Location>)intersections.iterator().next());
            }
            if (intersections.size() != 2) break block17;
            Iterator<Location> iterator = intersections.iterator();
            Location location1 = iterator.next();
            Location location2 = iterator.next();
            if (!location1.getLatitude().equals(location2.getLatitude()) && !location1.getLongitude().equals(location2.getLongitude())) {
                return Rectangle.forLocations(location1, location2);
            }
            if (location1.getLatitude().equals(location2.getLatitude())) {
                if (this.width().isLessThanOrEqualTo(other.width())) {
                    for (Location missing : this) {
                        if (!other.fullyGeometricallyEncloses(missing)) continue;
                        return Rectangle.forLocations(location1, location2, missing);
                    }
                } else {
                    for (Location missing : other) {
                        if (!this.fullyGeometricallyEncloses(missing)) continue;
                        return Rectangle.forLocations(location1, location2, missing);
                    }
                }
            }
            if (location1.getLongitude().equals(location2.getLongitude())) {
                if (this.height().isLessThanOrEqualTo(other.height())) {
                    for (Location missing : this) {
                        if (!other.fullyGeometricallyEncloses(missing)) continue;
                        return Rectangle.forLocations(location1, location2, missing);
                    }
                } else {
                    for (Location missing : other) {
                        if (!this.fullyGeometricallyEncloses(missing)) continue;
                        return Rectangle.forLocations(location1, location2, missing);
                    }
                }
            }
        }
        throw new CoreException("Cannot have more than 2 intersections.");
    }

    public Location lowerLeft() {
        return this.lowerLeft;
    }

    public Location lowerRight() {
        return new Location(this.lowerLeft.getLatitude(), this.upperRight.getLongitude());
    }

    @Override
    public boolean overlaps(PolyLine other) {
        if (other instanceof Rectangle) {
            Rectangle otherRectangle = (Rectangle)other;
            return !otherRectangle.lowerLeft.getLongitude().isGreaterThan(this.upperRight.getLongitude()) && !otherRectangle.upperRight.getLongitude().isLessThan(this.lowerLeft.getLongitude()) && !otherRectangle.upperRight.getLatitude().isLessThan(this.lowerLeft.getLatitude()) && !otherRectangle.lowerLeft.getLatitude().isGreaterThan(this.upperRight.getLatitude());
        }
        return super.overlaps(other);
    }

    @Override
    public Surface surface() {
        return Surface.forAngles(this.height(), this.width());
    }

    @Override
    public String toCompactString() {
        return this.lowerLeft.toCompactString() + ":" + this.upperRight.toCompactString();
    }

    public Location upperLeft() {
        return new Location(this.upperRight.getLatitude(), this.lowerLeft.getLongitude());
    }

    public Location upperRight() {
        return this.upperRight;
    }

    public Angle width() {
        return Angle.dm7(this.upperRight.getLongitude().asDm7() - this.lowerLeft.getLongitude().asDm7());
    }

    protected Rectangle2D asAwtRectangle() {
        int xAxis = (int)this.upperLeft().getLongitude().asDm7();
        int yAxis = (int)this.upperLeft().getLatitude().asDm7();
        int width = (int)(this.upperRight().getLongitude().asDm7() - this.upperLeft().getLongitude().asDm7());
        int height = (int)(this.upperLeft().getLatitude().asDm7() - this.lowerLeft().getLatitude().asDm7());
        return new java.awt.Rectangle(xAxis, yAxis, width, height);
    }
}

