/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.openstreetmap.atlas.geography.converters.MultiPolygonStringConverter;
import org.openstreetmap.atlas.geography.converters.WkbMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.WktMultiPolygonConverter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.scalars.Surface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPolygon
implements Iterable<Polygon>,
GeometricSurface,
Serializable,
GeoJsonGeometry {
    private static final Logger logger = LoggerFactory.getLogger(MultiPolygon.class);
    private static final long serialVersionUID = 4198234682870043547L;
    private static final int SIMPLE_STRING_LENGTH = 200;
    public static final MultiPolygon MAXIMUM = MultiPolygon.forPolygon(Rectangle.MAXIMUM);
    public static final MultiPolygon TEST_MULTI_POLYGON;
    private final MultiMap<Polygon, Polygon> outerToInners;
    private Rectangle bounds;

    public static MultiPolygon forOuters(Iterable<Polygon> polygons) {
        MultiMap<Polygon, Polygon> multiMap = new MultiMap<Polygon, Polygon>();
        polygons.forEach(polygon -> multiMap.put((Polygon)polygon, Collections.emptyList()));
        return new MultiPolygon(multiMap);
    }

    public static MultiPolygon forOuters(Polygon ... polygons) {
        return MultiPolygon.forOuters(Arrays.asList(polygons));
    }

    public static MultiPolygon forPolygon(Polygon polygon) {
        MultiMap<Polygon, Polygon> multiMap = new MultiMap<Polygon, Polygon>();
        multiMap.put(polygon, new ArrayList());
        return new MultiPolygon(multiMap);
    }

    public static MultiPolygon wkt(String wkt) {
        return new WktMultiPolygonConverter().backwardConvert(wkt);
    }

    public MultiPolygon(MultiMap<Polygon, Polygon> outerToInners) {
        this.outerToInners = outerToInners;
    }

    public GeoJsonObject asGeoJsonFeatureCollection() {
        GeoJsonBuilder builder = new GeoJsonBuilder();
        return builder.createFeatureCollection(Iterables.translate(this.outers(), outerPolygon -> builder.createOneOuterMultiPolygon(new MultiIterable<Polygon>(new Iterable[]{Collections.singleton(outerPolygon), this.outerToInners.get(outerPolygon)}))));
    }

    @Override
    public JsonObject asGeoJsonGeometry() {
        return GeoJsonUtils.geometry(GeoJsonType.MULTI_POLYGON, GeoJsonUtils.multiPolygonToCoordinates(this));
    }

    public Iterable<GeoJsonBuilder.LocationIterableProperties> asLocationIterableProperties() {
        Iterable<GeoJsonBuilder.LocationIterableProperties> outers = Iterables.translate(this.outers(), polygon -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("MultiPolygon", "outer");
            return new GeoJsonBuilder.LocationIterableProperties((Iterable<Location>)polygon, (Map<String, String>)tags);
        });
        Iterable<GeoJsonBuilder.LocationIterableProperties> inners = Iterables.translate(this.inners(), polygon -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("MultiPolygon", "inner");
            return new GeoJsonBuilder.LocationIterableProperties((Iterable<Location>)polygon, (Map<String, String>)tags);
        });
        return new MultiIterable<GeoJsonBuilder.LocationIterableProperties>(outers, inners);
    }

    public Optional<Polygon> asSimplePolygon() {
        if (this.isSimplePolygon()) {
            return this.outers().stream().findFirst();
        }
        logger.warn("Trying to read complex MultiPolygon as simple Polygon");
        return Optional.empty();
    }

    @Override
    public Rectangle bounds() {
        if (this.bounds == null && !this.isEmpty()) {
            HashSet<Location> locations = new HashSet<Location>();
            this.forEach(polygon -> polygon.forEach(locations::add));
            this.bounds = Rectangle.forLocations(locations);
        }
        return this.bounds;
    }

    public Clip clip(MultiPolygon clipping, Clip.ClipType clipType) {
        return new Clip(clipType, this, clipping);
    }

    public MultiPolygon concatenate(MultiPolygon other) {
        MultiMap<Polygon, Polygon> result = new MultiMap<Polygon, Polygon>();
        result.putAll(this.getOuterToInners());
        result.putAll(other.getOuterToInners());
        return new MultiPolygon(result);
    }

    public boolean equals(Object other) {
        if (other instanceof MultiPolygon) {
            MultiPolygon that = (MultiPolygon)other;
            Set<Polygon> thatOuters = that.outers();
            if (thatOuters.size() != this.outers().size()) {
                return false;
            }
            for (Polygon outer : this.outers()) {
                if (!thatOuters.contains(outer)) {
                    return false;
                }
                List<Polygon> thatInners = that.innersOf(outer);
                if (thatInners.size() != this.innersOf(outer).size()) {
                    return false;
                }
                for (Polygon inner : this.innersOf(outer)) {
                    if (thatInners.contains(inner)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fullyGeometricallyEncloses(Location location) {
        for (Polygon outer : this.outers()) {
            if (!outer.fullyGeometricallyEncloses(location)) continue;
            boolean result = true;
            for (Polygon inner : this.innersOf(outer)) {
                if (!inner.fullyGeometricallyEncloses(location)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean fullyGeometricallyEncloses(MultiPolygon that) {
        RTree<Polygon> thisOuters = RTree.forLocated(this.outers());
        for (Polygon thatOuter : that.outers()) {
            boolean enclosedWithoutInnerOverlap = false;
            for (Polygon thisOuter : thisOuters.get(thatOuter.bounds(), thatOuter::overlaps)) {
                if (!thisOuter.fullyGeometricallyEncloses(thatOuter)) continue;
                enclosedWithoutInnerOverlap = this.getOuterToInners().get(thisOuter).stream().noneMatch(that::overlaps);
            }
            if (enclosedWithoutInnerOverlap) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean fullyGeometricallyEncloses(PolyLine polyLine) {
        for (Polygon outer : this.outers()) {
            if (!outer.fullyGeometricallyEncloses(polyLine)) continue;
            return this.getOuterToInners().get(outer).stream().noneMatch(inner -> inner.overlaps(polyLine));
        }
        return false;
    }

    @Override
    public GeoJsonType getGeoJsonType() {
        return GeoJsonType.MULTI_POLYGON;
    }

    public int hashCode() {
        int result = 0;
        for (Polygon polygon : this) {
            result += polygon.hashCode();
        }
        return result;
    }

    public List<Polygon> inners() {
        return this.outerToInners.allValues();
    }

    public List<Polygon> innersOf(Polygon outer) {
        if (this.outerToInners.containsKey(outer)) {
            return this.outerToInners.get(outer);
        }
        return new ArrayList<Polygon>();
    }

    public boolean intersects(PolyLine polyLine) {
        for (Polygon outer : this.outers()) {
            if (!outer.intersects(polyLine)) continue;
            return true;
        }
        for (Polygon inner : this.inners()) {
            if (!inner.intersects(polyLine)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.outerToInners.isEmpty();
    }

    public boolean isSimplePolygon() {
        return this.outers().size() == 1;
    }

    @Override
    public Iterator<Polygon> iterator() {
        return new MultiIterable(this.outers(), this.inners()).iterator();
    }

    public MultiPolygon merge(MultiPolygon other) {
        MultiMap<Polygon, Polygon> result = new MultiMap<Polygon, Polygon>();
        result.putAll(this.getOuterToInners());
        result.addAll(other.getOuterToInners());
        return new MultiPolygon(result);
    }

    public Set<Polygon> outers() {
        return this.outerToInners.keySet();
    }

    @Override
    public boolean overlaps(MultiPolygon otherMultiPolygon) {
        return this.outers().stream().anyMatch(otherMultiPolygon::overlaps) && otherMultiPolygon.outers().stream().anyMatch(this::overlaps);
    }

    @Override
    public boolean overlaps(PolyLine polyLine) {
        return this.overlapsInternal(polyLine, true);
    }

    public void saveAsGeoJson(WritableResource resource) {
        JsonWriter writer = new JsonWriter(resource);
        writer.write(this.asGeoJson());
        writer.close();
    }

    @Override
    public Surface surface() {
        Surface result = Surface.MINIMUM;
        for (Polygon outer : this.outers()) {
            result = result.add(outer.surface());
        }
        for (Polygon inner : this.inners()) {
            result = result.subtract(inner.surface());
        }
        return result;
    }

    @Override
    public Surface surfaceOnSphere() {
        Surface result = Surface.MINIMUM;
        for (Polygon outer : this.outers()) {
            result = result.add(outer.surfaceOnSphere());
        }
        for (Polygon inner : this.inners()) {
            result = result.subtract(inner.surfaceOnSphere());
        }
        return result;
    }

    public String toCompactString() {
        return new MultiPolygonStringConverter().backwardConvert(this);
    }

    public String toReadableString() {
        String separator1 = "\n\t";
        String separator2 = "\n\t\t";
        StringBuilder builder = new StringBuilder();
        StringList outers = new StringList();
        for (Polygon outer : this.outers()) {
            StringList inners = new StringList();
            for (Polygon inner : this.innersOf(outer)) {
                inners.add("Inner: " + inner.toCompactString());
            }
            outers.add("Outer: " + outer.toCompactString() + "\n\t\t" + inners.join("\n\t\t"));
        }
        builder.append(outers.join("\n\t"));
        return builder.toString();
    }

    public String toSimpleString() {
        String string = this.toCompactString();
        if (string.length() > 201) {
            return string.substring(0, 200) + "...";
        }
        return string;
    }

    public String toString() {
        return this.toWkt();
    }

    @Override
    public byte[] toWkb() {
        return new WkbMultiPolygonConverter().convert(this);
    }

    @Override
    public String toWkt() {
        return new WktMultiPolygonConverter().convert(this);
    }

    public MultiMap<Polygon, Polygon> getOuterToInners() {
        return this.outerToInners;
    }

    private boolean overlapsInternal(PolyLine polyLine, boolean runReverseCheck) {
        for (Location location : polyLine) {
            if (!this.fullyGeometricallyEncloses(location)) continue;
            return true;
        }
        if (runReverseCheck && polyLine instanceof Polygon) {
            Polygon polygon = (Polygon)polyLine;
            for (Polygon outer : this.outers()) {
                if (!polygon.overlaps(outer)) continue;
                boolean result = true;
                for (Polygon inner : this.innersOf(outer)) {
                    if (!inner.fullyGeometricallyEncloses(polygon)) continue;
                    result = false;
                    break;
                }
                if (!result) continue;
                return true;
            }
        }
        return this.intersects(polyLine);
    }

    static {
        MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
        Polygon outer = new Polygon(Location.CROSSING_85_280, Location.CROSSING_85_17, Location.TEST_1, Location.TEST_5);
        Polygon inner = new Polygon(Location.TEST_6, Location.TEST_2, Location.TEST_7);
        outerToInners.add(outer, inner);
        TEST_MULTI_POLYGON = new MultiPolygon(outerToInners);
    }
}

