/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import org.openstreetmap.atlas.utilities.scalars.Angle;

public class Latitude
extends Angle {
    private static final long serialVersionUID = -1737858321716005802L;
    protected static final int MINIMUM_DM7 = -900000000;
    protected static final int MAXIMUM_DM7 = 900000000;
    public static final Latitude MINIMUM = Latitude.dm7(-900000000L);
    public static final Latitude ZERO = Latitude.dm7(0L);
    public static final Latitude MAXIMUM = Latitude.dm7(900000000L);

    public static Latitude degrees(double degrees2) {
        return Latitude.dm7(Math.round(degrees2 * 1.0E7));
    }

    public static Latitude dm7(long dm7) {
        if (dm7 < -900000000L || dm7 > 900000000L) {
            throw new IllegalArgumentException("Cannot have a latitude of " + dm7 / 10000000L + " degrees which is outside of " + -90 + " degrees -> " + 90 + " degrees.");
        }
        return new Latitude((int)dm7);
    }

    public static Latitude radians(double radians2) {
        return Latitude.dm7(Math.round(radians2 * 5.72957795E8));
    }

    public static Latitude radiansBounded(double radians2) {
        long dm7 = Math.round(radians2 * 5.72957795E8);
        if (dm7 < -900000000L) {
            dm7 = -900000000L;
        }
        if (dm7 > 900000000L) {
            dm7 = 900000000L;
        }
        return Latitude.dm7(dm7);
    }

    protected Latitude(int dm7) {
        super(dm7);
        if (dm7 < -900000000 || dm7 > 900000000) {
            throw new IllegalArgumentException("Invalid Latitude microdegrees value: " + dm7);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.asDegrees());
    }
}

