/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.caching;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.NamespaceCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopAtlasFileCache
extends ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(HadoopAtlasFileCache.class);
    private static final String GLOBAL_HADOOP_FILECACHE_NAMESPACE = "__HadoopAtlasFileCache_global_namespace__";
    private final String parentAtlasPath;
    private final SlippyTilePersistenceScheme atlasScheme;

    public HadoopAtlasFileCache(String parentAtlasPath, Map<String, String> configuration) {
        this(parentAtlasPath, GLOBAL_HADOOP_FILECACHE_NAMESPACE, AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, SlippyTilePersistenceScheme atlasScheme, Map<String, String> configuration) {
        this(parentAtlasPath, GLOBAL_HADOOP_FILECACHE_NAMESPACE, atlasScheme, configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, String namespace, Map<String, String> configuration) {
        this(parentAtlasPath, namespace, AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, String namespace, SlippyTilePersistenceScheme atlasScheme, Map<String, String> configuration) {
        super(new NamespaceCachingStrategy(namespace), (URI uri) -> {
            if (!FileSystemHelper.exists(uri.toString(), configuration)) {
                logger.warn("Fetcher: resource {} does not exist!", uri);
                return Optional.empty();
            }
            return Optional.ofNullable(FileSystemHelper.resource(uri.toString(), configuration));
        });
        this.parentAtlasPath = parentAtlasPath;
        this.atlasScheme = atlasScheme;
    }

    public Optional<Resource> get(String country, Shard shard) {
        return this.get(this.getURIFromCountryAndShard(country, shard));
    }

    public void invalidate(String country, Shard shard) {
        this.invalidate(this.getURIFromCountryAndShard(country, shard));
    }

    private URI getURIFromCountryAndShard(String country, Shard shard) {
        URI atlasURI;
        String compiledAtlasScheme = "";
        if (shard instanceof SlippyTile) {
            compiledAtlasScheme = this.atlasScheme.compile((SlippyTile)shard);
        }
        String atlasName = String.format("%s_%s", country, shard.getName());
        String atlasURIString = SparkFileHelper.combine(this.parentAtlasPath, country, compiledAtlasScheme, atlasName + FileSuffix.ATLAS.toString());
        try {
            atlasURI = new URI(atlasURIString);
        }
        catch (URISyntaxException exception) {
            throw new CoreException("Bad URI syntax: {}", atlasURIString, exception);
        }
        return atlasURI;
    }
}

