/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence.scheme;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public enum SlippyTilePersistenceSchemeType {
    ZZ_XX_YY_PBF("zz-xx-yy", FileSuffix.PBF),
    ZZ_SLASH_XX_YY_PBF(SparkFileHelper.combine("zz", "xx-yy"), FileSuffix.PBF),
    ZZ_XX_YY_SUBFOLDERS_PBF(SparkFileHelper.combine("zz", "xx", "yy", "zz-xx-yy"), FileSuffix.PBF),
    ZZ_XX_YY_OSMPBF("zz-xx-yy", FileSuffix.OSMPBF),
    ZZ_SLASH_XX_YY_OSMPBF(SparkFileHelper.combine("zz", "xx-yy"), FileSuffix.OSMPBF),
    ZZ_SLASH_ZZ_XX_YY_OSMPBF(SparkFileHelper.combine("zz", "zz-xx-yy"), FileSuffix.OSMPBF),
    ZZ_XX_YY_SUBFOLDERS_OSMPBF(SparkFileHelper.combine("zz", "xx", "yy", "zz-xx-yy"), FileSuffix.OSMPBF),
    ZZ_SUBFOLDER("zz/", FileSuffix.NONE),
    EMPTY("", FileSuffix.NONE);

    private String value;
    private FileSuffix suffix;

    static SlippyTilePersistenceSchemeType enumNameToSchemeType(String string) {
        for (SlippyTilePersistenceSchemeType type : SlippyTilePersistenceSchemeType.values()) {
            if (!type.name().equalsIgnoreCase(string)) continue;
            return type;
        }
        throw new CoreException("Invalid SlippyTilePersistenceSchemeType name {}", string);
    }

    static SlippyTilePersistenceSchemeType legacyArbitrarySchemeToSchemeType(String string) {
        for (SlippyTilePersistenceSchemeType type : SlippyTilePersistenceSchemeType.values()) {
            String schemeString = type.getValue() + type.getSuffix().toString();
            if (!schemeString.equals(string)) continue;
            return type;
        }
        return null;
    }

    private SlippyTilePersistenceSchemeType(String value, FileSuffix suffix) {
        this.value = value;
        this.suffix = suffix;
    }

    public FileSuffix getSuffix() {
        return this.suffix;
    }

    public String getValue() {
        return this.value;
    }
}

