/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public final class AtlasGeneratorParameters {
    private static final String SHARDING_DEFAULT = "slippy@10";
    public static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be included in the final Atlas", value -> StringList.split(value, ","), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY_SHAPES = new Command.Switch<String>("countryShapes", "Shape file containing the countries", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> PBF_PATH = new Command.Switch<String>("pbfs", "The path to PBFs", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<SlippyTilePersistenceScheme> PBF_SCHEME = new Command.Switch("pbfScheme", "The folder structure of the PBF", SlippyTilePersistenceScheme::getSchemeInstanceFromString, Command.Optionality.OPTIONAL, PbfLocator.DEFAULT_SCHEME);
    public static final Command.Switch<String> PBF_SHARDING = new Command.Switch<String>("pbfSharding", "The sharding tree of the pbf files. If not specified, this will default to the general Atlas sharding.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<SlippyTilePersistenceScheme> ATLAS_SCHEME = new Command.Switch("atlasScheme", "The folder structure of the output Atlas. Example: \"zz/xx/yy/\" or \"\" (everything under the same folder)", SlippyTilePersistenceScheme::getSchemeInstanceFromString, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch<String>("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "slippy@10");
    public static final Command.Switch<String> PREVIOUS_OUTPUT_FOR_DELTA = new Command.Switch<String>("previousOutputForDelta", "The path of the output of the previous job that can be used for delta computation", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<String> CODE_VERSION = new Command.Switch<String>("codeVersion", "The code version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> DATA_VERSION = new Command.Switch<String>("dataVersion", "The data version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> EDGE_CONFIGURATION = new Command.Switch<String>("edgeConfiguration", "The path to the configuration file that defines what OSM Way becomes an Edge", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> WAY_SECTIONING_CONFIGURATION = new Command.Switch<String>("waySectioningConfiguration", "The path to the configuration file that defines where to section Ways to make Edges.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_WAY_CONFIGURATION = new Command.Switch<String>("osmPbfWayConfiguration", "The path to the configuration file that defines which PBF Ways becomes an Atlas Entity.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_NODE_CONFIGURATION = new Command.Switch<String>("osmPbfNodeConfiguration", "The path to the configuration file that defines which PBF Nodes becomes an Atlas Entity.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_RELATION_CONFIGURATION = new Command.Switch<String>("osmPbfRelationConfiguration", "The path to the configuration file that defines which PBF Relations becomes an Atlas Entity", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHOULD_ALWAYS_SLICE_CONFIGURATION = new Command.Switch<String>("shouldAlwaysSliceConfiguration", "The path to the configuration file that defines which entities on which country slicing will always be attempted regardless of the number of countries it intersects according to the country boundary map's grid index.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHOULD_INCLUDE_FILTERED_OUTPUT_CONFIGURATION = new Command.Switch<String>("shouldIncludeFilteredOutputConfiguration", "The path to the configuration file that defines which will be included in filtered output. Filtered output will only be generated if this switch is specificed, and will be stored in a separate subdirectory.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<Boolean> USE_JAVA_FORMAT = new Command.Switch("useJavaFormat", "Generate the atlas files using the java serialization atlas format (as opposed to the protobuf format).", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    public static final Command.Switch<Boolean> LINE_DELIMITED_GEOJSON_OUTPUT = new Command.Switch("lineDelimitedGeojsonOutput", "Output each shard as a line delimited geojson outout file in the ldgeojson folder.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");

    public static StandardConfiguration getStandardConfigurationFrom(Resource configurationResource) {
        return new StandardConfiguration(configurationResource);
    }

    public static ConfiguredTaggableFilter getTaggableFilterFrom(Resource configurationResource) {
        return new ConfiguredTaggableFilter(AtlasGeneratorParameters.getStandardConfigurationFrom(configurationResource));
    }

    protected static AtlasLoadingOption buildAtlasLoadingOption(CountryBoundaryMap boundaries, Map<String, String> properties) {
        String pbfRelationConfiguration;
        String pbfWayConfiguration;
        String pbfNodeConfiguration;
        String waySectioningConfiguration;
        AtlasLoadingOption atlasLoadingOption = AtlasLoadingOption.createOptionWithAllEnabled(boundaries);
        String edgeConfiguration = properties.get(EDGE_CONFIGURATION.getName());
        if (edgeConfiguration != null) {
            atlasLoadingOption.setEdgeFilter(AtlasGeneratorParameters.getTaggableFilterFrom(new StringResource(edgeConfiguration)));
        }
        if ((waySectioningConfiguration = properties.get(WAY_SECTIONING_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setWaySectionFilter(AtlasGeneratorParameters.getTaggableFilterFrom(new StringResource(waySectioningConfiguration)));
        }
        if ((pbfNodeConfiguration = properties.get(PBF_NODE_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfNodeFilter(AtlasGeneratorParameters.getTaggableFilterFrom(new StringResource(pbfNodeConfiguration)));
        }
        if ((pbfWayConfiguration = properties.get(PBF_WAY_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfWayFilter(AtlasGeneratorParameters.getTaggableFilterFrom(new StringResource(pbfWayConfiguration)));
        }
        if ((pbfRelationConfiguration = properties.get(PBF_RELATION_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfRelationFilter(AtlasGeneratorParameters.getTaggableFilterFrom(new StringResource(pbfRelationConfiguration)));
        }
        return atlasLoadingOption;
    }

    protected static Map<String, String> extractAtlasLoadingProperties(CommandMap command, Map<String, String> sparkContext) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(CODE_VERSION.getName(), (String)command.get(CODE_VERSION));
        propertyMap.put(DATA_VERSION.getName(), (String)command.get(DATA_VERSION));
        String edgeConfiguration = (String)command.get(EDGE_CONFIGURATION);
        propertyMap.put(EDGE_CONFIGURATION.getName(), edgeConfiguration == null ? null : FileSystemHelper.resource(edgeConfiguration, sparkContext).all());
        String waySectioningConfiguration = (String)command.get(WAY_SECTIONING_CONFIGURATION);
        propertyMap.put(WAY_SECTIONING_CONFIGURATION.getName(), waySectioningConfiguration == null ? null : FileSystemHelper.resource(waySectioningConfiguration, sparkContext).all());
        String pbfNodeConfiguration = (String)command.get(PBF_NODE_CONFIGURATION);
        propertyMap.put(PBF_NODE_CONFIGURATION.getName(), pbfNodeConfiguration == null ? null : FileSystemHelper.resource(pbfNodeConfiguration, sparkContext).all());
        String pbfWayConfiguration = (String)command.get(PBF_WAY_CONFIGURATION);
        propertyMap.put(PBF_WAY_CONFIGURATION.getName(), pbfWayConfiguration == null ? null : FileSystemHelper.resource(pbfWayConfiguration, sparkContext).all());
        String pbfRelationConfiguration = (String)command.get(PBF_RELATION_CONFIGURATION);
        propertyMap.put(PBF_RELATION_CONFIGURATION.getName(), pbfRelationConfiguration == null ? null : FileSystemHelper.resource(pbfRelationConfiguration, sparkContext).all());
        return propertyMap;
    }

    protected static Command.SwitchList switches() {
        return new Command.SwitchList().with(COUNTRIES, COUNTRY_SHAPES, SHARDING_TYPE, PBF_PATH, PBF_SCHEME, PBF_SHARDING, PREVIOUS_OUTPUT_FOR_DELTA, CODE_VERSION, DATA_VERSION, EDGE_CONFIGURATION, WAY_SECTIONING_CONFIGURATION, PBF_NODE_CONFIGURATION, PBF_WAY_CONFIGURATION, PBF_RELATION_CONFIGURATION, ATLAS_SCHEME, SHOULD_ALWAYS_SLICE_CONFIGURATION, USE_JAVA_FORMAT, LINE_DELIMITED_GEOJSON_OUTPUT, SHOULD_INCLUDE_FILTERED_OUTPUT_CONFIGURATION);
    }

    private AtlasGeneratorParameters() {
    }
}

