/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGenerationTask;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.AtlasLocator;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.caching.HadoopAtlasFileCache;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.delta.AtlasDelta;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.Counter;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.system.memory.Memory;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class AtlasGeneratorHelper
implements Serializable {
    private static final long serialVersionUID = 1300098384789754747L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasGeneratorHelper.class);
    private static final String LINE_SLICED_SUBATLAS_NAMESPACE = "lineSlicedSubAtlas";
    private static final String LINE_SLICED_ATLAS_NAMESPACE = "lineSlicedAtlas";
    static final Predicate<Taggable> linePredicate = entity -> entity instanceof Line && Validators.isOfType((Taggable)entity, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER, NaturalTag.COASTLINE});
    static final Predicate<Taggable> relationPredicate = entity -> {
        if (!(entity instanceof Relation)) return false;
        if (!((Relation)entity).flatten().stream().anyMatch(linePredicate::test)) return false;
        return true;
    };
    public static final Predicate<Taggable> subAtlasFilter = (Predicate<Taggable> & Serializable)entity -> linePredicate.test((Taggable)entity) || relationPredicate.test((Taggable)entity);
    private static final AtlasResourceLoader ATLAS_LOADER = new AtlasResourceLoader();

    public static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache lineSlicedSubAtlasCache, HadoopAtlasFileCache lineSlicedAtlasCache, CountryBoundaryMap boundaries, String countryBeingSliced, Shard initialShard) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            StringList countriesForShardList = boundaries.countryCodesOverlappingWith(shard.bounds());
            HashSet countriesForShard = new HashSet();
            countriesForShardList.forEach(countriesForShard::add);
            HashSet<Resource> atlasResources = new HashSet<Resource>();
            if (shard.equals(initialShard)) {
                Optional<Resource> cachedInitialShardResource = lineSlicedAtlasCache.get(countryBeingSliced, (Shard)shard);
                if (cachedInitialShardResource.isPresent()) {
                    atlasResources.add(cachedInitialShardResource.get());
                    countriesForShard.remove(countryBeingSliced);
                } else {
                    logger.error("No Atlas file found for initial Shard {}!", shard);
                    return Optional.empty();
                }
            }
            countriesForShard.forEach(country -> {
                Optional<Resource> cachedAtlas = lineSlicedSubAtlasCache.get((String)country, (Shard)shard);
                if (cachedAtlas.isPresent()) {
                    logger.debug("Cache hit, loading sliced subAtlas for Shard {} and country {}", shard, country);
                    atlasResources.add(cachedAtlas.get());
                }
            });
            return Optional.ofNullable(MultiAtlas.loadFromPackedAtlas(atlasResources));
        };
    }

    public static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache subAtlasCache, HadoopAtlasFileCache atlasCache, String countryBeingSliced, Shard initialShard) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            Optional<Resource> cachedInitialShardResource = shard.equals(initialShard) ? atlasCache.get(countryBeingSliced, (Shard)shard) : subAtlasCache.get(countryBeingSliced, (Shard)shard);
            if (!cachedInitialShardResource.isPresent()) {
                logger.error("No Atlas file found for initial Shard {}!", shard);
                return Optional.empty();
            }
            return Optional.ofNullable(ATLAS_LOADER.load(cachedInitialShardResource.get()));
        };
    }

    protected static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache atlasCache, String country, Set<Shard> validShards) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            if (!validShards.isEmpty() && !validShards.contains(shard)) {
                logger.debug("Ignoring loading request for invalid shard {}", shard);
                return Optional.empty();
            }
            Optional<Resource> cachedAtlasResource = atlasCache.get(country, (Shard)shard);
            if (cachedAtlasResource.isPresent()) {
                logger.debug("Cache hit, returning loaded atlas for shard {}", shard);
                return Optional.ofNullable(ATLAS_LOADER.load(cachedAtlasResource.get()));
            }
            logger.debug("No atlas file found for shard {}", shard);
            return Optional.empty();
        };
    }

    protected static PairFlatMapFunction<Tuple2<String, Atlas>, String, AtlasDelta> computeAtlasDelta(Map<String, String> sparkContext, String previousOutputForDelta) {
        return (PairFlatMapFunction & Serializable)tuple -> {
            String countryShardName = (String)tuple._1();
            Atlas current = (Atlas)tuple._2();
            logger.info("Starting computing deltas for Atlas {}", (Object)current.getName());
            Time start = Time.now();
            ArrayList<Tuple2> result = new ArrayList<Tuple2>();
            try {
                Optional<Atlas> alter = new AtlasLocator(sparkContext).atlasForShard(SparkFileHelper.combine(previousOutputForDelta, StringList.split(countryShardName, "_").get(0)), countryShardName);
                if (alter.isPresent()) {
                    logger.info("Printing memory after other Atlas loaded for Delta {}", (Object)current.getName());
                    Memory.printCurrentMemory();
                    AtlasDelta delta = new AtlasDelta(current, alter.get()).generate();
                    result.add(new Tuple2((Object)countryShardName, (Object)delta));
                }
            }
            catch (Exception e) {
                logger.error("Skipping! Could not generate deltas for {}", (Object)current.getName(), (Object)e);
            }
            logger.info("Finished computing deltas for Atlas {} in {}", (Object)current.getName(), (Object)start.elapsedSince());
            return result;
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, AtlasStatistics> generateAtlasStatistics(Broadcast<Sharding> sharding) {
        return (PairFunction & Serializable)tuple -> {
            String shardName = (String)tuple._1();
            logger.info("Starting generating Atlas statistics for {}", (Object)shardName);
            Time start = Time.now();
            Counter counter = new Counter().withSharding((Sharding)sharding.getValue());
            counter.setCountsDefinition(Counter.POI_COUNTS_DEFINITION.getDefault());
            AtlasStatistics statistics = new AtlasStatistics();
            try {
                statistics = counter.processAtlas((Atlas)tuple._2());
                logger.info("Finished generating Atlas statistics for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            }
            catch (Exception e) {
                logger.error("Building Atlas Statistics for {} failed!", (Object)shardName, (Object)e);
            }
            return new Tuple2((Object)shardName, (Object)statistics);
        };
    }

    protected static PairFunction<AtlasGenerationTask, String, Atlas> generateRawAtlas(Broadcast<CountryBoundaryMap> boundaries, Map<String, String> sparkContext, Broadcast<Map<String, String>> loadingOptions, PbfContext pbfContext, SlippyTilePersistenceScheme atlasScheme) {
        return (PairFunction & Serializable)task -> {
            Atlas atlas;
            String countryName = task.getCountry();
            Shard shard = task.getShard();
            String name = countryName + "_" + shard.getName();
            logger.info("Starting creating raw Atlas {}", (Object)name);
            Time start = Time.now();
            AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
            atlasLoadingOption.setAdditionalCountryCodes(countryName);
            PbfLoader loader = new PbfLoader(pbfContext, sparkContext, (CountryBoundaryMap)boundaries.getValue(), atlasLoadingOption, (String)((Map)loadingOptions.getValue()).get(AtlasGeneratorParameters.CODE_VERSION.getName()), (String)((Map)loadingOptions.getValue()).get(AtlasGeneratorParameters.DATA_VERSION.getName()), task.getAllShards());
            try {
                atlas = loader.generateRawAtlas(countryName, shard);
            }
            catch (Throwable e) {
                throw new CoreException("Building raw Atlas {} failed!", name, e);
            }
            logger.info("Finished creating raw Atlas {} in {}", (Object)name, (Object)start.elapsedSince());
            logger.info("Printing memory after loading raw Atlas {}", (Object)name);
            Memory.printCurrentMemory();
            return new Tuple2((Object)(name + "_" + atlasScheme.getScheme()), (Object)atlas);
        };
    }

    protected static Function2<NamedAtlasStatistics, NamedAtlasStatistics, NamedAtlasStatistics> reduceAtlasStatistics() {
        return (Function2 & Serializable)(left, right) -> {
            try {
                return new NamedAtlasStatistics(left.getName(), AtlasStatistics.merge(left.getAtlasStatistics(), right.getAtlasStatistics()));
            }
            catch (Throwable e) {
                logger.error("Unable to merge AtlasStatistics for {}! Returning the first one only.\nLeft:\n{}\nRight:\n{}", new Object[]{left.getName(), left.getAtlasStatistics(), right.getAtlasStatistics(), e});
                return left;
            }
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sectionRawAtlas(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Sharding> sharding, Map<String, String> sparkContext, Broadcast<Map<String, String>> loadingOptions, String edgeSubAtlasPath, String slicedAtlasPath, SlippyTilePersistenceScheme atlasScheme, List<AtlasGenerationTask> tasks) {
        return (PairFunction & Serializable)tuple -> {
            Atlas atlas;
            Time start = Time.now();
            try {
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                String countryShardString = (String)tuple._1();
                CountryShard countryShard = CountryShard.forName(countryShardString);
                String country = countryShard.getCountry();
                Set<Shard> possibleShards = AtlasGeneratorHelper.getAllShardsForCountry(tasks, country);
                HadoopAtlasFileCache atlasCache = new HadoopAtlasFileCache(slicedAtlasPath, atlasScheme, sparkContext);
                HadoopAtlasFileCache edgeSubCache = new HadoopAtlasFileCache(edgeSubAtlasPath, atlasScheme, sparkContext);
                Function<Shard, Optional<Atlas>> slicedRawAtlasFetcher = AtlasGeneratorHelper.atlasFetcher(edgeSubCache, atlasCache, country, countryShard.getShard());
                atlas = new WaySectionProcessor(countryShard.getShard(), atlasLoadingOption, (Sharding)sharding.getValue(), slicedRawAtlasFetcher).run();
            }
            catch (Throwable e) {
                throw new CoreException("Sectioning Raw Atlas for {} failed!", tuple._1(), e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("Finished sectioning raw Atlas for {} in {}", tuple._1(), (Object)start.elapsedSince());
                logger.info("Printing memory after loading final Atlas for {}", tuple._1());
                Memory.printCurrentMemory();
            }
            return new Tuple2((Object)((String)tuple._1()), (Object)atlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceRawAtlas(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Map<String, String>> loadingOptions) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            String shardName = (String)tuple._1();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info("Starting slicing raw Atlas {}", (Object)rawAtlas.getName());
            Time start = Time.now();
            try {
                String countryName = shardName.split("_")[0];
                if (countryName != null) {
                    AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                    atlasLoadingOption.setAdditionalCountryCodes(countryName);
                    slicedAtlas = new RawAtlasCountrySlicer(atlasLoadingOption).slice(rawAtlas);
                } else {
                    slicedAtlas = null;
                    logger.error("Unable to extract valid country code for {}", (Object)shardName);
                }
            }
            catch (Throwable e) {
                throw new CoreException("Slicing raw Atlas failed for {}", shardName, e);
            }
            logger.info("Finished slicing raw Atlas for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading sliced raw Atlas for {}", (Object)shardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)slicedAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceRawAtlasLines(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Map<String, String>> loadingOptions) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            String shardName = (String)tuple._1();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info("Starting line slicing raw Atlas {}", (Object)rawAtlas.getName());
            Time start = Time.now();
            try {
                String countryName = shardName.split("_")[0];
                if (countryName != null) {
                    AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                    atlasLoadingOption.setAdditionalCountryCodes(countryName);
                    logger.error("Country codes during line slicing was: {}", atlasLoadingOption.getCountryCodes());
                    slicedAtlas = new RawAtlasCountrySlicer(atlasLoadingOption).sliceLines(rawAtlas);
                } else {
                    slicedAtlas = null;
                    logger.error("Unable to extract valid country code for {}", (Object)shardName);
                }
            }
            catch (Throwable e) {
                throw new CoreException("Line slicing raw Atlas failed for {}", shardName, e);
            }
            logger.info("Finished line slicing raw Atlas for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading line sliced raw Atlas for {}", (Object)shardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), slicedAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceRawAtlasRelations(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Map<String, String>> loadingOptions, Broadcast<Sharding> sharding, String lineSlicedSubAtlasPath, String lineSlicedAtlasPath, SlippyTilePersistenceScheme atlasScheme, Map<String, String> sparkContext) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            String shardName = (String)tuple._1();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info("Starting relation slicing raw Atlas {}", (Object)rawAtlas.getName());
            Time start = Time.now();
            try {
                String countryShardString = (String)tuple._1();
                CountryShard countryShard = CountryShard.forName(countryShardString);
                String country = countryShard.getCountry();
                HadoopAtlasFileCache lineSlicedSubAtlasCache = new HadoopAtlasFileCache(lineSlicedSubAtlasPath, LINE_SLICED_SUBATLAS_NAMESPACE, atlasScheme, sparkContext);
                HadoopAtlasFileCache lineSlicedAtlasCache = new HadoopAtlasFileCache(lineSlicedAtlasPath, LINE_SLICED_ATLAS_NAMESPACE, atlasScheme, sparkContext);
                Function<Shard, Optional<Atlas>> atlasFetcher = AtlasGeneratorHelper.atlasFetcher(lineSlicedSubAtlasCache, lineSlicedAtlasCache, (CountryBoundaryMap)boundaries.getValue(), country, countryShard.getShard());
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                atlasLoadingOption.setAdditionalCountryCodes(country);
                slicedAtlas = new RawAtlasCountrySlicer(atlasLoadingOption, (Sharding)sharding.getValue(), atlasFetcher).sliceRelations(countryShard.getShard());
            }
            catch (Throwable e) {
                throw new CoreException("Relation slicing raw Atlas failed for {}", shardName, e);
            }
            logger.info("Finished relation slicing raw Atlas for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading fully sliced Atlas for {}", (Object)shardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)slicedAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> subatlas(Predicate<Taggable> filter, AtlasCutType cutType) {
        return (PairFunction & Serializable)tuple -> {
            Atlas subAtlas;
            String shardName = (String)tuple._1();
            Atlas originalAtlas = (Atlas)tuple._2();
            logger.info("Starting sub Atlas for for Atlas {}", (Object)originalAtlas.getName());
            Time start = Time.now();
            try {
                Optional<Atlas> subAtlasOptional = originalAtlas.subAtlas(filter::test, cutType);
                if (subAtlasOptional.isPresent()) {
                    subAtlas = subAtlasOptional.get();
                } else {
                    subAtlas = null;
                    logger.error("Unable to extract valid subAtlas code for {}", (Object)shardName);
                }
            }
            catch (Throwable e) {
                throw new CoreException("Sub Atlas failed for {}", shardName, e);
            }
            logger.info("Finished sub Atlas for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading sub Atlas for {}", (Object)shardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)subAtlas);
        };
    }

    private static Set<Shard> getAllShardsForCountry(List<AtlasGenerationTask> tasks, String country) {
        for (AtlasGenerationTask task : tasks) {
            if (!task.getCountry().equals(country)) continue;
            return task.getAllShards();
        }
        logger.debug("Could not find shards for {}", (Object)country);
        return Collections.emptySet();
    }

    private AtlasGeneratorHelper() {
    }

    protected static class NamedAtlasStatistics
    implements Serializable {
        private static final long serialVersionUID = 1593790111775268766L;
        private final String name;
        private final AtlasStatistics atlasStatistics;

        public NamedAtlasStatistics(String name, AtlasStatistics atlasStatistics) {
            this.name = name;
            this.atlasStatistics = atlasStatistics;
        }

        public AtlasStatistics getAtlasStatistics() {
            return this.atlasStatistics;
        }

        public String getName() {
            return this.name;
        }
    }
}

