/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.openstreetmap.atlas.generator.AtlasGenerationTask;
import org.openstreetmap.atlas.generator.AtlasGeneratorHelper;
import org.openstreetmap.atlas.generator.AtlasGeneratorJobGroup;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.persistence.MultipleLineDelimitedGeojsonOutputFormat;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMapArchiver;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class AtlasGenerator
extends SparkJob {
    private static final long serialVersionUID = 5985696743749843135L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasGenerator.class);
    private static final String SAVED_MESSAGE = "\n\n********** SAVED FOR STEP: {} **********\n";
    public static final String LINE_DELIMITED_GEOJSON_STATISTICS_FOLDER = "ldgeojson";

    public static void main(String[] args) {
        new AtlasGenerator().run(args);
    }

    protected static List<AtlasGenerationTask> generateTasks(StringList countries, CountryBoundaryMap boundaryMap, Sharding sharding) {
        MultiMapWithSet<String, Shard> countryToShardMap = CountryShardListing.countryToShardList(countries, boundaryMap, sharding);
        ArrayList<AtlasGenerationTask> tasks = new ArrayList<AtlasGenerationTask>();
        countryToShardMap.keySet().forEach(country -> {
            Object shards = countryToShardMap.get(country);
            if (!shards.isEmpty()) {
                shards.forEach(arg_0 -> AtlasGenerator.lambda$generateTasks$0(tasks, country, (Set)shards, arg_0));
            } else {
                logger.warn("No shards were found for {}. Skipping task generation.", country);
            }
        });
        return tasks;
    }

    @Override
    public String getName() {
        return "Atlas Generator";
    }

    @Override
    public void start(CommandMap command) {
        Map<String, String> sparkContext = this.configurationMap();
        StringList countries = (StringList)command.get(AtlasGeneratorParameters.COUNTRIES);
        String countryShapes = (String)command.get(AtlasGeneratorParameters.COUNTRY_SHAPES);
        String previousOutputForDelta = (String)command.get(AtlasGeneratorParameters.PREVIOUS_OUTPUT_FOR_DELTA);
        String pbfPath = (String)command.get(AtlasGeneratorParameters.PBF_PATH);
        SlippyTilePersistenceScheme pbfScheme = (SlippyTilePersistenceScheme)command.get(AtlasGeneratorParameters.PBF_SCHEME);
        SlippyTilePersistenceScheme atlasScheme = (SlippyTilePersistenceScheme)command.get(AtlasGeneratorParameters.ATLAS_SCHEME);
        String pbfShardingName = (String)command.get(AtlasGeneratorParameters.PBF_SHARDING);
        String shardingName = (String)command.get(AtlasGeneratorParameters.SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingName, this.configuration());
        Sharding pbfSharding = pbfShardingName != null ? AtlasSharding.forString(pbfShardingName, this.configuration()) : sharding;
        PbfContext pbfContext = new PbfContext(pbfPath, pbfSharding, pbfScheme);
        String shouldAlwaysSliceConfiguration = (String)command.get(AtlasGeneratorParameters.SHOULD_ALWAYS_SLICE_CONFIGURATION);
        String shouldIncludeFilteredOutputConfiguration = (String)command.get(AtlasGeneratorParameters.SHOULD_INCLUDE_FILTERED_OUTPUT_CONFIGURATION);
        ConfiguredTaggableFilter taggableOutputFilter = shouldIncludeFilteredOutputConfiguration == null ? taggable -> false : AtlasGeneratorParameters.getTaggableFilterFrom(FileSystemHelper.resource(shouldIncludeFilteredOutputConfiguration, sparkContext));
        ConfiguredTaggableFilter shouldAlwaysSlicePredicate = shouldAlwaysSliceConfiguration == null ? taggable -> false : AtlasGeneratorParameters.getTaggableFilterFrom(FileSystemHelper.resource(shouldAlwaysSliceConfiguration, sparkContext));
        String output = this.output(command);
        boolean useJavaFormat = (Boolean)command.get(AtlasGeneratorParameters.USE_JAVA_FORMAT);
        boolean lineDelimitedGeojsonOutput = (Boolean)command.get(AtlasGeneratorParameters.LINE_DELIMITED_GEOJSON_OUTPUT);
        Resource countryBoundaries = this.resource(countryShapes);
        logger.info("Reading country boundaries from {}", (Object)countryShapes);
        CountryBoundaryMap boundaries = new CountryBoundaryMapArchiver().read(countryBoundaries);
        logger.info("Done Reading {} country boundaries from {}", (Object)boundaries.size(), (Object)countryShapes);
        if (!boundaries.hasGridIndex()) {
            logger.warn("Given country boundary file didn't have grid index. Initializing grid index for {}.", (Object)countries);
            boundaries.initializeGridIndex(countries.stream().collect(Collectors.toSet()));
        }
        boundaries.setShouldAlwaysSlicePredicate(shouldAlwaysSlicePredicate);
        Time timer = Time.now();
        List<AtlasGenerationTask> tasks = AtlasGenerator.generateTasks(countries, boundaries, sharding);
        logger.debug("Generated {} tasks in {}.", (Object)tasks.size(), (Object)timer.elapsedSince());
        Map<String, String> atlasLoadingOptions = AtlasGeneratorParameters.extractAtlasLoadingProperties(command, sparkContext);
        Broadcast broadcastBoundaries = this.getContext().broadcast((Object)boundaries);
        Broadcast broadcastLoadingOptions = this.getContext().broadcast(atlasLoadingOptions);
        Broadcast broadcastSharding = this.getContext().broadcast((Object)sharding);
        JavaPairRDD countryRawAtlasRDD = this.getContext().parallelize(tasks, tasks.size()).mapToPair(AtlasGeneratorHelper.generateRawAtlas((Broadcast<CountryBoundaryMap>)broadcastBoundaries, sparkContext, (Broadcast<Map<String, String>>)broadcastLoadingOptions, pbfContext, atlasScheme)).filter((Function & Serializable)tuple -> tuple._2() != null);
        countryRawAtlasRDD.cache();
        this.saveAsHadoop(countryRawAtlasRDD, AtlasGeneratorJobGroup.RAW, output);
        JavaPairRDD lineSlicedAtlasRDD = countryRawAtlasRDD.mapToPair(AtlasGeneratorHelper.sliceRawAtlasLines((Broadcast<CountryBoundaryMap>)broadcastBoundaries, (Broadcast<Map<String, String>>)broadcastLoadingOptions)).filter((Function & Serializable)tuple -> tuple._2() != null);
        lineSlicedAtlasRDD.cache();
        this.saveAsHadoop(lineSlicedAtlasRDD, AtlasGeneratorJobGroup.LINE_SLICED, output);
        countryRawAtlasRDD.unpersist();
        JavaPairRDD lineSlicedSubAtlasRDD = lineSlicedAtlasRDD.mapToPair(AtlasGeneratorHelper.subatlas(AtlasGeneratorHelper.subAtlasFilter, AtlasCutType.SILK_CUT)).filter((Function & Serializable)tuple -> tuple._2() != null);
        lineSlicedSubAtlasRDD.cache();
        this.saveAsHadoop(lineSlicedSubAtlasRDD, AtlasGeneratorJobGroup.LINE_SLICED_SUB, output);
        JavaPairRDD fullySlicedRawAtlasShardsRDD = lineSlicedAtlasRDD.mapToPair(AtlasGeneratorHelper.sliceRawAtlasRelations((Broadcast<CountryBoundaryMap>)broadcastBoundaries, (Broadcast<Map<String, String>>)broadcastLoadingOptions, (Broadcast<Sharding>)broadcastSharding, this.getAlternateSubFolderOutput(output, AtlasGeneratorJobGroup.LINE_SLICED_SUB.getCacheFolder()), this.getAlternateSubFolderOutput(output, AtlasGeneratorJobGroup.LINE_SLICED.getCacheFolder()), atlasScheme, sparkContext)).filter((Function & Serializable)tuple -> tuple._2() != null);
        fullySlicedRawAtlasShardsRDD.cache();
        this.saveAsHadoop(fullySlicedRawAtlasShardsRDD, AtlasGeneratorJobGroup.FULLY_SLICED, output);
        lineSlicedAtlasRDD.unpersist();
        lineSlicedSubAtlasRDD.unpersist();
        ConfiguredTaggableFilter edgeFilter = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)broadcastBoundaries.getValue(), (Map)broadcastLoadingOptions.getValue()).getEdgeFilter();
        JavaPairRDD edgeOnlySubAtlasRDD = fullySlicedRawAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.subatlas(edgeFilter, AtlasCutType.SILK_CUT)).filter((Function & Serializable)tuple -> tuple._2() != null);
        edgeOnlySubAtlasRDD.cache();
        this.saveAsHadoop(edgeOnlySubAtlasRDD, AtlasGeneratorJobGroup.EDGE_SUB, output);
        JavaPairRDD countryAtlasShardsRDD = fullySlicedRawAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.sectionRawAtlas((Broadcast<CountryBoundaryMap>)broadcastBoundaries, (Broadcast<Sharding>)broadcastSharding, sparkContext, (Broadcast<Map<String, String>>)broadcastLoadingOptions, this.getAlternateSubFolderOutput(output, AtlasGeneratorJobGroup.EDGE_SUB.getCacheFolder()), this.getAlternateSubFolderOutput(output, AtlasGeneratorJobGroup.FULLY_SLICED.getCacheFolder()), atlasScheme, tasks));
        countryAtlasShardsRDD.cache();
        edgeOnlySubAtlasRDD.unpersist();
        if (useJavaFormat) {
            this.saveAsHadoop(countryAtlasShardsRDD, AtlasGeneratorJobGroup.WAY_SECTIONED, output);
        } else {
            this.saveAsHadoop(countryAtlasShardsRDD, AtlasGeneratorJobGroup.WAY_SECTIONED_PBF, output);
        }
        if (lineDelimitedGeojsonOutput) {
            countryAtlasShardsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, LINE_DELIMITED_GEOJSON_STATISTICS_FOLDER), Text.class, String.class, MultipleLineDelimitedGeojsonOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE LINE DELIMITED GEOJSON ATLAS **********\n");
        }
        fullySlicedRawAtlasShardsRDD.unpersist();
        JavaPairRDD statisticsRDD = countryAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.generateAtlasStatistics((Broadcast<Sharding>)broadcastSharding));
        statisticsRDD.cache();
        this.saveAsHadoop(statisticsRDD, AtlasGeneratorJobGroup.SHARD_STATISTICS, output);
        JavaPairRDD reducedStatisticsRDD = statisticsRDD.mapToPair((PairFunction & Serializable)tuple -> {
            String countryShardName = (String)tuple._1();
            String countryName = StringList.split(countryShardName, "_").get(0);
            return new Tuple2((Object)countryName, (Object)new AtlasGeneratorHelper.NamedAtlasStatistics(countryName, (AtlasStatistics)tuple._2()));
        }).reduceByKey(AtlasGeneratorHelper.reduceAtlasStatistics()).mapToPair((PairFunction & Serializable)tuple -> new Tuple2((Object)((String)tuple._1()), (Object)((AtlasGeneratorHelper.NamedAtlasStatistics)tuple._2()).getAtlasStatistics()));
        this.saveAsHadoop(reducedStatisticsRDD, AtlasGeneratorJobGroup.COUNTRY_STATISTICS, output);
        statisticsRDD.unpersist();
        if (!previousOutputForDelta.isEmpty()) {
            JavaPairRDD deltasRDD = countryAtlasShardsRDD.flatMapToPair(AtlasGeneratorHelper.computeAtlasDelta(sparkContext, previousOutputForDelta));
            this.saveAsHadoop(deltasRDD, AtlasGeneratorJobGroup.DELTAS, output);
        }
        if (shouldIncludeFilteredOutputConfiguration != null) {
            JavaPairRDD subAtlasRDD = countryAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.subatlas(taggableOutputFilter, AtlasCutType.SOFT_CUT)).filter((Function & Serializable)tuple -> tuple._2() != null);
            this.saveAsHadoop(subAtlasRDD, AtlasGeneratorJobGroup.TAGGABLE_FILTERED_OUTPUT, output);
        }
        countryAtlasShardsRDD.unpersist();
    }

    @Override
    protected List<String> outputToClean(CommandMap command) {
        String output = this.output(command);
        List<String> staticPaths = super.outputToClean(command);
        for (AtlasGeneratorJobGroup group : AtlasGeneratorJobGroup.values()) {
            staticPaths.add(this.getAlternateSubFolderOutput(output, group.getCacheFolder()));
        }
        return staticPaths;
    }

    @Override
    protected Command.SwitchList switches() {
        Command.SwitchList result = super.switches();
        result.addAll(AtlasGeneratorParameters.switches());
        return result;
    }

    private void saveAsHadoop(JavaPairRDD<?, ?> atlasRDD, AtlasGeneratorJobGroup group, String output) {
        this.getContext().setJobGroup(group.getId().toString(), group.getDescription());
        atlasRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, group.getCacheFolder()), Text.class, group.getKeyClass(), group.getOutputClass(), new JobConf(this.configuration()));
        logger.info(SAVED_MESSAGE, (Object)group.getDescription());
    }

    private static /* synthetic */ void lambda$generateTasks$0(List tasks, String country, Set shards, Shard shard) {
        tasks.add(new AtlasGenerationTask(country, shard, shards));
    }
}

