/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class SignPostCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 8042255121118115024L;
    private static final String JUNCTION_NODE_INSTRUCTION = "Junction node {0,number,#} is missing a highway=motorway_junction tag.";
    private static final String DESTINATION_TAG_INSTRUCTION = "Way {0,number,#} is missing a destination tag.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Junction node {0,number,#} is missing a highway=motorway_junction tag.", "Way {0,number,#} is missing a destination tag.");
    private static final double DISTANCE_MINIMUM_METERS_DEFAULT = 50.0;
    private static final String SOURCE_EDGE_FILTER_DEFAULT = "highway->motorway,trunk";
    private static final String RAMP_FILTER_DEFAULT = "highway->motorway_link,trunk_link";
    private static final String DESTINATION_TAG_FILTER_DEFAULT = "destination->*|destination:ref->*|destination:street->*|destination:backward->*|destination:forwards->*";
    private final Distance minimumLinkLength;
    private final TaggableFilter sourceEdgeFilter;
    private final TaggableFilter rampEdgeFilter;
    private final TaggableFilter destinationTagFilter;
    private final boolean checkLinkBranches;

    public SignPostCheck(Configuration configuration) {
        super(configuration);
        this.minimumLinkLength = this.configurationValue(configuration, "link.length.minimum.meters", 50.0, Distance::meters);
        this.sourceEdgeFilter = this.configurationValue(configuration, "source.filter", SOURCE_EDGE_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.rampEdgeFilter = this.configurationValue(configuration, "ramp.filter", RAMP_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.destinationTagFilter = this.configurationValue(configuration, "destination_tag.filter", DESTINATION_TAG_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.checkLinkBranches = this.configurationValue(configuration, "link.branch.check", true);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMasterEdge() && !this.isFlagged(String.valueOf(object.getOsmIdentifier())) && this.rampEdgeFilter.test(object) && ((Edge)object).highwayTag().isLink() && ((Edge)object).length().isGreaterThan(this.minimumLinkLength);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        HighwayTag highwayTag = edge.highwayTag();
        CheckFlag flag = new CheckFlag(String.valueOf(object.getOsmIdentifier()));
        HashSet<Node> junctionNodes = new HashSet<Node>();
        boolean checkDestination = false;
        HashSet<Edge> inEdges = new HashSet<Edge>(edge.inEdges());
        edge.reversed().ifPresent(reverseEdge -> inEdges.addAll(reverseEdge.inEdges()));
        for (Edge inEdge : inEdges) {
            if (this.sourceEdgeFilter.test(inEdge)) {
                checkDestination = true;
                junctionNodes.add(inEdge.end());
                continue;
            }
            if (!inEdge.highwayTag().equals((Object)highwayTag)) {
                checkDestination = true;
                continue;
            }
            if (!this.checkLinkBranches || !this.isLinkStem(inEdge)) continue;
            checkDestination = true;
        }
        junctionNodes.forEach(node -> {
            if (!Validators.isOfType((Taggable)node, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY_JUNCTION})) {
                flag.addInstruction(this.getLocalizedInstruction(0, node.getOsmIdentifier()));
                flag.addObject((AtlasObject)node);
            }
        });
        if (checkDestination && !this.destinationTagFilter.test(edge) && edge.relations().stream().noneMatch(relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.DESTINATION_SIGN}))) {
            flag.addInstruction(this.getLocalizedInstruction(1, edge.getOsmIdentifier()));
            flag.addObject(edge);
        }
        if (!flag.getFlaggedObjects().isEmpty()) {
            this.markAsFlagged(String.valueOf(object.getOsmIdentifier()));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isLinkStem(Edge edge) {
        return edge.outEdges().stream().filter(outEdge -> outEdge.highwayTag().equals((Object)edge.highwayTag()) && outEdge.getIdentifier() != edge.getIdentifier()).count() >= 2L;
    }
}

