/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class MalformedRoundaboutCheck
extends BaseCheck {
    private static final long serialVersionUID = -3018101860747289836L;
    private static final String BASIC_INSTRUCTION = "This roundabout is malformed.";
    private static final String WRONG_WAY_INSTRUCTIONS = "This roundabout is going the wrong direction, or has been improperly tagged as a roundabout.";
    private static final String INCOMPLETE_ROUTE_INSTRUCTIONS = "This roundabout does not form a single, one-way, complete, car navigable route.";
    private static final String ENCLOSED_ROADS_INSTRUCTIONS = "This roundabout has car navigable ways inside it.";
    private static final List<String> LEFT_DRIVING_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BGD", "BHS", "BMU", "BRB", "BRN", "BTN", "BWA", "CCK", "COK", "CXR", "CYM", "CYP", "DMA", "FJI", "FLK", "GBR", "GGY", "GRD", "GUY", "HKG", "IDN", "IMN", "IND", "IRL", "JAM", "JEY", "JPN", "KEN", "KIR", "KNA", "LCA", "LKA", "LSO", "MAC", "MDV", "MLT", "MOZ", "MSR", "MUS", "MWI", "MYS", "NAM", "NFK", "NIU", "NPL", "NRU", "NZL", "PAK", "PCN", "PNG", "SGP", "SGS", "SHN", "SLB", "SUR", "SWZ", "SYC", "TCA", "THA", "TKL", "TLS", "TON", "TTO", "TUV", "TZA", "UGA", "VCT", "VGB", "VIR", "WSM", "ZAF", "ZMB", "ZWE");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout is going the wrong direction, or has been improperly tagged as a roundabout.", "This roundabout does not form a single, one-way, complete, car navigable route.", "This roundabout has car navigable ways inside it.", "This roundabout is malformed.");
    private List<String> leftDrivingCountries;

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    public MalformedRoundaboutCheck(Configuration configuration) {
        super(configuration);
        this.leftDrivingCountries = this.configurationValue(configuration, "traffic.countries.left", LEFT_DRIVING_COUNTRIES_DEFAULT);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && object.getTag("iso_country_code").isPresent() && JunctionTag.isRoundabout(object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMasterEdge() && !this.isExcludedHighway(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Route roundaboutEdges;
        Edge edge = (Edge)object;
        String isoCountryCode = edge.tag("iso_country_code").toUpperCase();
        HashSet<String> instructions = new HashSet<String>();
        Set<AtlasObject> roundaboutEdgeSet = new SimpleEdgeWalker(edge, this.isRoundaboutEdge()).collectEdges();
        roundaboutEdgeSet.forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
        try {
            roundaboutEdges = Route.fromNonArrangedEdgeSet(roundaboutEdgeSet, false);
        }
        catch (CoreException badRoundabout) {
            return Optional.of(this.createFlag(roundaboutEdgeSet, this.getLocalizedInstruction(1, new Object[0])));
        }
        if (roundaboutEdgeSet.stream().anyMatch(roundaboutEdge -> !HighwayTag.isCarNavigableHighway(roundaboutEdge) || !roundaboutEdge.isMasterEdge()) || !roundaboutEdges.start().inEdges().contains(roundaboutEdges.end())) {
            instructions.add(this.getLocalizedInstruction(1, new Object[0]));
        }
        RoundaboutDirection direction = MalformedRoundaboutCheck.findRoundaboutDirection(roundaboutEdges);
        boolean isLeftDriving = this.leftDrivingCountries.contains(isoCountryCode);
        if (direction.equals((Object)RoundaboutDirection.CLOCKWISE) && !isLeftDriving || direction.equals((Object)RoundaboutDirection.COUNTERCLOCKWISE) && isLeftDriving) {
            instructions.add(this.getLocalizedInstruction(0, new Object[0]));
        }
        if (roundaboutEdgeSet.stream().noneMatch(this::ignoreBridgeTunnelCrossings) && this.roundaboutEnclosesRoads(roundaboutEdges)) {
            instructions.add(this.getLocalizedInstruction(2, new Object[0]));
        }
        if (!instructions.isEmpty()) {
            CheckFlag flag = this.createFlag(roundaboutEdgeSet, this.getLocalizedInstruction(3, new Object[0]));
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(connected -> JunctionTag.isRoundabout(connected) && !this.isExcludedHighway((AtlasObject)connected));
    }

    private static RoundaboutDirection findRoundaboutDirection(Route roundaboutEdges) {
        int clockwiseCount = 0;
        int counterClockwiseCount = 0;
        for (int idx = 0; idx < roundaboutEdges.size(); ++idx) {
            RoundaboutDirection direction;
            Edge edge2;
            Edge edge1 = roundaboutEdges.get(idx);
            double crossProduct = MalformedRoundaboutCheck.getCrossProduct(edge1, edge2 = roundaboutEdges.get((idx + 1) % roundaboutEdges.size()));
            RoundaboutDirection roundaboutDirection = crossProduct < 0.0 ? RoundaboutDirection.COUNTERCLOCKWISE : (direction = crossProduct > 0.0 ? RoundaboutDirection.CLOCKWISE : RoundaboutDirection.UNKNOWN);
            if (direction.equals((Object)RoundaboutDirection.UNKNOWN)) continue;
            if (direction.equals((Object)RoundaboutDirection.CLOCKWISE)) {
                ++clockwiseCount;
            }
            if (!direction.equals((Object)RoundaboutDirection.COUNTERCLOCKWISE)) continue;
            ++counterClockwiseCount;
        }
        if (clockwiseCount > counterClockwiseCount) {
            return RoundaboutDirection.CLOCKWISE;
        }
        if (clockwiseCount < counterClockwiseCount) {
            return RoundaboutDirection.COUNTERCLOCKWISE;
        }
        return RoundaboutDirection.UNKNOWN;
    }

    private static Double getCrossProduct(Edge edge1, Edge edge2) {
        double node1Y = edge1.start().getLocation().getLatitude().asDegrees();
        double node1X = edge1.start().getLocation().getLongitude().asDegrees();
        double node2Y = edge1.end().getLocation().getLatitude().asDegrees();
        double node2X = edge1.end().getLocation().getLongitude().asDegrees();
        double node3Y = edge2.end().getLocation().getLatitude().asDegrees();
        double node3X = edge2.end().getLocation().getLongitude().asDegrees();
        double vector1X = node2X - node1X;
        double vector1Y = node2Y - node1Y;
        double vector2X = node2X - node3X;
        double vector2Y = node2Y - node3Y;
        return vector1X * vector2Y - vector1Y * vector2X;
    }

    private boolean ignoreBridgeTunnelCrossings(Edge edge) {
        return Validators.hasValuesFor(edge, LayerTag.class) || BridgeTag.isBridge(edge) || TunnelTag.isTunnel(edge);
    }

    private boolean roundaboutEnclosesRoads(Route roundabout) {
        Polygon roundaboutPoly = new Polygon(roundabout.asPolyLine());
        return roundabout.start().getAtlas().edgesIntersecting(roundaboutPoly, edge -> HighwayTag.isCarNavigableHighway(edge) && !JunctionTag.isRoundabout(edge) && !this.ignoreBridgeTunnelCrossings((Edge)edge) && this.intersectsWithEnclosedGeometry(roundaboutPoly, (Edge)edge)).iterator().hasNext();
    }

    private boolean intersectsWithEnclosedGeometry(Polygon polygon, Edge edge) {
        PolyLine polyline = edge.asPolyLine();
        return polygon.intersections(polyline).stream().anyMatch(intersection -> !edge.start().getLocation().equals(intersection) && !edge.end().getLocation().equals(intersection) || polygon.fullyGeometricallyEncloses(polyline));
    }

    private boolean isExcludedHighway(AtlasObject object) {
        return Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CYCLEWAY, HighwayTag.PEDESTRIAN, HighwayTag.FOOTWAY});
    }

    public static enum RoundaboutDirection {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        UNKNOWN;

    }
}

