/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.AccessTag;
import org.openstreetmap.atlas.tags.AmenityTag;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.CoveredTag;
import org.openstreetmap.atlas.tags.EntranceTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.ServiceTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class BuildingRoadIntersectionCheck
extends BaseCheck<Long> {
    private static final String BUILDING_ROAD_INTERSECTION_INSTRUCTION = "Building (id-{0,number,#}) intersects road (id-{1,number,#})";
    private static final String SERVICE_ROAD_INTERSECTION_INSTRUCTION = "Building (id-{0,number,#}) intersects road (id-{1,number,#}), which is a SERVICE road. Please verify whether the intersection is valid or not.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Building (id-{0,number,#}) intersects road (id-{1,number,#})", "Building (id-{0,number,#}) intersects road (id-{1,number,#}), which is a SERVICE road. Please verify whether the intersection is valid or not.");
    private static final String INDOOR_KEY = "indoor";
    private static final String YES_VALUE = "yes";
    private static final Predicate<Edge> HIGHWAY_SERVICE_TAG = edge -> Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.SERVICE});
    private final Boolean carNavigableEdgesOnly;
    private static final long serialVersionUID = 5986017212661374165L;

    private static Predicate<Edge> ignoreTags() {
        return edge -> !Validators.isOfType((Taggable)edge, CoveredTag.class, (Enum[])new CoveredTag[]{CoveredTag.YES}) && !Validators.isOfType((Taggable)edge, TunnelTag.class, (Enum[])new TunnelTag[]{TunnelTag.BUILDING_PASSAGE, TunnelTag.YES}) && !Validators.isOfType((Taggable)edge, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES}) && !YES_VALUE.equals(edge.tag(INDOOR_KEY)) && (!HIGHWAY_SERVICE_TAG.test((Edge)edge) || !Validators.isOfType((Taggable)edge, ServiceTag.class, (Enum[])new ServiceTag[]{ServiceTag.DRIVEWAY})) && !edge.connectedNodes().stream().anyMatch(node -> Validators.isOfType((Taggable)node, EntranceTag.class, (Enum[])new EntranceTag[]{EntranceTag.YES}) || Validators.isOfType((Taggable)node, AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.PARKING_ENTRANCE}) || Validators.hasValuesFor(node, BarrierTag.class));
    }

    private Predicate<Edge> intersectsCoreWayInvalidly(Area building) {
        return edge -> (this.carNavigableEdgesOnly != false ? HighwayTag.isCarNavigableHighway(edge) : HighwayTag.isCoreWay(edge)) && edge.asPolyLine().intersects(building.asPolygon()) && (!HIGHWAY_SERVICE_TAG.test((Edge)edge) || !Validators.isOfType((Taggable)building, AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.FUEL})) && LayerTag.getTaggedValue(edge).orElse(0L).equals(LayerTag.getTaggedValue(building).orElse(0L)) && !BuildingRoadIntersectionCheck.isValidIntersection(building, edge) && !Validators.isOfType((Taggable)edge, AccessTag.class, (Enum[])new AccessTag[]{AccessTag.PRIVATE});
    }

    private static boolean isValidIntersection(Area building, Edge edge) {
        Node edgeStart = edge.start();
        Node edgeEnd = edge.end();
        Set<Location> intersections = building.asPolygon().intersections(edge.asPolyLine());
        return intersections.size() == 1 && !building.asPolygon().fullyGeometricallyEncloses(edge.asPolyLine()) && (intersections.contains(edgeStart.getLocation()) || intersections.contains(edgeEnd.getLocation()));
    }

    public BuildingRoadIntersectionCheck(Configuration configuration) {
        super(configuration);
        this.carNavigableEdgesOnly = this.configurationValue(configuration, "car.navigable", true);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && BuildingTag.isBuilding(object) && !HighwayTag.isHighwayArea(object) && !Validators.isOfType((Taggable)object, AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.PARKING}) && !Validators.isOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ROOF}) && !object.getAtlas().pointsWithin(((Area)object).asPolygon(), point -> Validators.isOfType((Taggable)point, AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.FUEL})).iterator().hasNext();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area building = (Area)object;
        Iterable<Edge> intersectingEdges = Iterables.filter(building.getAtlas().edgesIntersecting(building.bounds(), this.intersectsCoreWayInvalidly(building)), BuildingRoadIntersectionCheck.ignoreTags());
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier(building));
        flag.addObject(building);
        this.handleIntersections(intersectingEdges, flag, building);
        return flag.getPolyLines().size() > 1 ? Optional.of(flag) : Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private void handleIntersections(Iterable<Edge> intersectingEdges, CheckFlag flag, Area building) {
        HashSet<Edge> knownIntersections = new HashSet<Edge>();
        for (Edge edge : intersectingEdges) {
            if (knownIntersections.contains(edge)) continue;
            int instructionIndex = HIGHWAY_SERVICE_TAG.test(edge) ? 1 : 0;
            flag.addObject(edge, this.getLocalizedInstruction(instructionIndex, building.getOsmIdentifier(), edge.getOsmIdentifier()));
            knownIntersections.add(edge);
            Optional<Edge> reversedEdge = edge.reversed();
            if (!reversedEdge.isPresent()) continue;
            knownIntersections.add(reversedEdge.get());
        }
    }
}

