/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.function.Function;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteClient;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeDifficulty;
import org.openstreetmap.atlas.checks.maproulette.data.ProjectConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.geography.atlas.AtlasLoadingCommand;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapRouletteCommand
extends AtlasLoadingCommand {
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteCommand.class);
    private static final boolean DEFAULT_ENABLED = true;
    private static final Command.Switch<MapRouletteConfiguration> MAP_ROULETTE = new Command.Switch("maproulette", "Map roulette server information, format <host>:<port>:<project>:<api_key>", MapRouletteConfiguration::parse);
    private static final Command.Switch<String> PROJECT_DISPLAY_NAME = new Command.Switch<String>("projectDisplayName", "Display name of the project under which all of the challenges will be submitted", StringConverter.IDENTITY);
    private MapRouletteClient mapRouletteClient;

    public MapRouletteClient getClient() {
        return this.mapRouletteClient;
    }

    protected synchronized void addTask(String challengeName, Task task) throws UnsupportedEncodingException, URISyntaxException {
        this.mapRouletteClient.addTask(new Challenge(challengeName, "", "", "", ChallengeDifficulty.EASY, ""), task);
    }

    protected synchronized void addTask(Challenge challenge, Task task) throws UnsupportedEncodingException, URISyntaxException {
        this.mapRouletteClient.addTask(challenge, task);
    }

    protected void checkUploadTasks(int threshold) {
        if (this.getMapRouletteClient().getCurrentBatchSize() >= threshold) {
            this.uploadTasks();
        }
    }

    protected abstract void execute(CommandMap var1, MapRouletteConfiguration var2);

    protected MapRouletteClient getMapRouletteClient() {
        return this.mapRouletteClient;
    }

    @Override
    protected int onRun(CommandMap commandMap) {
        return this.onRun(commandMap, MapRouletteClient::new);
    }

    protected int onRun(CommandMap commandMap, Function<MapRouletteConfiguration, MapRouletteClient> clientConstructor) {
        MapRouletteConfiguration mapRoulette = this.fromCommandMap(commandMap);
        if (mapRoulette != null) {
            try {
                this.mapRouletteClient = clientConstructor.apply(mapRoulette);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Failed to initialize the MapRouletteClient", (Throwable)e);
            }
        }
        this.execute(commandMap, mapRoulette);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(MAP_ROULETTE);
    }

    protected void uploadTasks() {
        if (this.mapRouletteClient != null) {
            this.mapRouletteClient.uploadTasks();
        }
    }

    private MapRouletteConfiguration fromCommandMap(CommandMap commandMap) {
        MapRouletteConfiguration mapRoulette = (MapRouletteConfiguration)commandMap.get(MAP_ROULETTE);
        String projectDisplayName = (String)commandMap.get(PROJECT_DISPLAY_NAME);
        if (projectDisplayName == null) {
            return mapRoulette;
        }
        ProjectConfiguration project = new ProjectConfiguration(mapRoulette.getProjectName(), mapRoulette.getProjectName(), projectDisplayName, true);
        return new MapRouletteConfiguration(mapRoulette.getScheme(), mapRoulette.getServer(), mapRoulette.getPort(), project, mapRoulette.getApiKey());
    }
}

