/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConnection;
import org.openstreetmap.atlas.checks.maproulette.TaskLoader;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.Project;
import org.openstreetmap.atlas.checks.maproulette.data.ProjectConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteClient
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteClient.class);
    private static final long serialVersionUID = -8121247154514856056L;
    private final Map<Tuple<String, String>, Set<Task>> batch = new ConcurrentHashMap<Tuple<String, String>, Set<Task>>();
    private final MapRouletteConfiguration configuration;
    private final TaskLoader connection;
    private final Map<String, Project> projects = new ConcurrentHashMap<String, Project>();
    private final Map<Long, Map<String, Challenge>> challenges = new ConcurrentHashMap<Long, Map<String, Challenge>>();

    public static MapRouletteClient instance(MapRouletteConfiguration configuration) {
        if (configuration != null && !configuration.getServer().isEmpty()) {
            try {
                return new MapRouletteClient(configuration);
            }
            catch (Exception e) {
                logger.warn(String.format("Failed to create MapRoulette client with [%s]. Will continue on, but will not push any tasks.", configuration), (Throwable)e);
            }
        }
        return null;
    }

    public MapRouletteClient(MapRouletteConfiguration configuration) {
        this(configuration, new MapRouletteConnection(configuration));
    }

    MapRouletteClient(MapRouletteConfiguration configuration, TaskLoader taskLoader) {
        this.configuration = configuration;
        this.connection = taskLoader;
    }

    public synchronized void addTask(Challenge challenge, Task task) {
        ProjectConfiguration projectConfiguration;
        if (this.configuration != null) {
            projectConfiguration = this.configuration.getProjectConfiguration();
            if (StringUtils.isEmpty(projectConfiguration.getName()) && StringUtils.isNotEmpty(task.getProjectName())) {
                projectConfiguration = new ProjectConfiguration(task.getProjectName());
            }
        } else {
            projectConfiguration = new ProjectConfiguration(task.getProjectName());
        }
        this.addTask(projectConfiguration, challenge, task);
    }

    public synchronized void addTask(String projectName, Challenge challenge, Task task) {
        this.addTask(new ProjectConfiguration(projectName), challenge, task);
    }

    public synchronized void addTask(ProjectConfiguration projectConfiguration, Challenge challenge, Task task) {
        task.setProjectName(projectConfiguration.getName());
        task.setChallengeName(challenge.getName());
        this.updateChallengeTaskList(challenge, task, projectConfiguration);
    }

    public int getCurrentBatchSize() {
        int size = 0;
        for (Tuple<String, String> key : this.batch.keySet()) {
            size += this.batch.get(key).size();
        }
        return size;
    }

    public void uploadTasks() {
        this.batch.forEach((key, value) -> this.upload((Tuple<String, String>)key));
    }

    public void uploadTasks(Tuple<String, String> key) {
        this.upload(key);
    }

    private Optional<Challenge> createChallenge(Project project, Challenge challenge) throws UnsupportedEncodingException, URISyntaxException {
        Map challengeMap = this.challenges.getOrDefault(project.getId(), new HashMap());
        challenge.setParentIdentifier(project.getId());
        if (!challengeMap.containsKey(challenge.getName())) {
            challenge.setId(this.connection.createChallenge(project, challenge));
            challengeMap.put(challenge.getName(), challenge);
            this.challenges.put(project.getId(), challengeMap);
        }
        return Optional.of(challenge);
    }

    private Project createProject(ProjectConfiguration projectConfiguration) throws UnsupportedEncodingException, URISyntaxException {
        String projectName = projectConfiguration.getName();
        Project project = this.projects.getOrDefault(projectName, projectConfiguration.buildProject());
        if (project.getId() == -1L) {
            project.setId(this.connection.createProject(project));
            this.projects.put(projectName, project);
        }
        return project;
    }

    private void updateChallengeTaskList(Challenge challenge, Task task, ProjectConfiguration projectConfiguration) throws CoreException {
        Optional<Task> duplicateTask;
        Tuple<String, String> taskKey = new Tuple<String, String>(task.getProjectName(), challenge.getName());
        Set<Task> challengeTaskList = this.batch.get(taskKey);
        if (challengeTaskList == null) {
            challengeTaskList = new HashSet<Task>();
        }
        if ((duplicateTask = challengeTaskList.stream().filter(setTask -> StringUtils.equals(setTask.getTaskIdentifier(), task.getTaskIdentifier())).findAny()).isPresent()) {
            logger.trace("Attempting to add a duplicate task to the batch with id {}, into Project '{}' and Challenge '{}'", new Object[]{task.getTaskIdentifier(), task.getProjectName(), challenge.getName()});
        } else {
            challengeTaskList.add(task);
            this.batch.put(taskKey, challengeTaskList);
            try {
                this.createChallenge(this.createProject(projectConfiguration), challenge);
            }
            catch (Exception e) {
                logger.warn(String.format("Failed to create/update project structure for %s/%s.", task.getProjectName(), challenge.getName()), (Throwable)e);
            }
        }
    }

    private void upload(Tuple<String, String> key) {
        Set<Task> batchList = this.batch.get(key);
        if (batchList != null && batchList.size() > 0) {
            try {
                Project project = this.projects.get(key.getFirst());
                if (project == null || project.getId() == -1L) {
                    logger.warn("Failed to upload batch to MapRoulette, Project {} has not been created.", (Object)key.getFirst());
                } else {
                    Challenge challenge = this.challenges.get(project.getId()).get(key.getSecond());
                    if (challenge == null || challenge.getId() == -1L) {
                        logger.warn("Failed to upload batch to MapRoulette, Challenge {} has not been created.", (Object)key.getSecond());
                    } else {
                        this.connection.uploadBatchTasks(challenge.getId(), batchList);
                        batchList.clear();
                    }
                }
            }
            catch (Exception e) {
                logger.warn(String.format("Failed to upload batch to MapRoulette [%s].", this.connection.getConnectionInfo()), (Throwable)e);
            }
        }
    }
}

