/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.atlas.checks.distributed.LogFilePathFilter;
import org.openstreetmap.atlas.checks.event.Event;
import org.openstreetmap.atlas.checks.event.Processor;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileProcessor<T extends Event>
implements Processor<T> {
    public static final int BATCH_SIZE = 2500;
    private static final Logger logger = LoggerFactory.getLogger(FileProcessor.class);
    private final SparkFileHelper fileHelper;
    private final String directory;
    private final StringBuffer buffer;
    private int batchSize = 2500;
    private final AtomicInteger counter;
    private final ReadWriteLock fileLock = new ReentrantReadWriteLock();
    private boolean compressOutput = true;

    public FileProcessor(SparkFileHelper fileHelper, String directory) {
        this.fileHelper = fileHelper;
        this.directory = directory;
        this.buffer = new StringBuffer();
        this.counter = new AtomicInteger(0);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final int getCount() {
        return this.counter.get();
    }

    public boolean doesCompressOutput() {
        return this.compressOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String event) {
        this.fileLock.readLock().lock();
        try {
            this.buffer.append(String.format("%s%s", event, System.lineSeparator()));
            this.counter.incrementAndGet();
        }
        catch (Exception e) {
            logger.warn("Event processing is failed.", (Throwable)e);
        }
        finally {
            this.fileLock.readLock().unlock();
        }
        if (this.counter.get() >= this.getBatchSize()) {
            this.fileLock.writeLock().lock();
            try {
                if (this.getCount() >= this.getBatchSize()) {
                    this.write();
                }
            }
            catch (Exception e) {
                logger.warn("File write is failed.", (Throwable)e);
            }
            finally {
                this.fileLock.writeLock().unlock();
            }
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public FileProcessor<T> withCompression(boolean compress) {
        this.compressOutput = compress;
        return this;
    }

    protected String getFilename() {
        return String.format("%s-%s%s", new Date().getTime(), this.getCount(), new LogFilePathFilter(this.compressOutput).getExtension());
    }

    protected void write() {
        int count = this.getCount();
        if (count == 0) {
            logger.warn("Writing empty file with no content in {}.", (Object)this.directory);
        }
        this.fileHelper.write(this.directory, this.getFilename(), this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
        this.counter.set(0);
    }
}

