/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.atlas.CountrySpecificAtlasFilePathFilter;
import org.openstreetmap.atlas.checks.atlas.OsmPbfFilePathFilter;
import org.openstreetmap.atlas.checks.distributed.AtlasFilePathResolver;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDataSource
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6407331424906155431L;
    private Atlas atlas = null;
    private final Logger logger = LoggerFactory.getLogger(AtlasDataSource.class);
    private final SparkFileHelper loadHelper;
    private final AtlasFilePathResolver pathResolver;
    private final MultiPolygon polygon;

    public AtlasDataSource(Map<String, String> sparkContext, Configuration configuration) {
        this(sparkContext, configuration, MultiPolygon.MAXIMUM);
    }

    public AtlasDataSource(Map<String, String> sparkContext, Configuration configuration, MultiPolygon polygon) {
        this.loadHelper = new SparkFileHelper(sparkContext);
        this.pathResolver = new AtlasFilePathResolver(configuration);
        this.polygon = polygon;
    }

    public AtlasDataSource(Map<String, String> sparkContext, Configuration configuration, Rectangle boundingBox) {
        this(sparkContext, configuration, MultiPolygon.forPolygon(boundingBox));
    }

    @Override
    public void close() throws Exception {
        this.atlas = null;
    }

    public Atlas getAtlas() {
        return this.atlas;
    }

    public Atlas load(String input, String country) {
        return this.load(input, country, intermediateAtlas -> {});
    }

    public Atlas load(String input, String country, Consumer<Atlas> intermediateAtlasHandler) {
        OsmPbfFilePathFilter pbfFilter = new OsmPbfFilePathFilter();
        CountrySpecificAtlasFilePathFilter atlasFilter = new CountrySpecificAtlasFilePathFilter(country);
        Optional<Resource> resource = this.loadHelper.collectSourceFile(input, pbfFilter, atlasFilter);
        if (resource.isPresent()) {
            Resource dataSource2 = resource.get();
            if (AtlasResourceLoader.IS_ATLAS.test(dataSource2)) {
                this.atlas = new AtlasResourceLoader().load(dataSource2);
            } else if (FileSuffix.resourceFilter(FileSuffix.PBF).test(dataSource2)) {
                this.logger.info("Loading Atlas from OSM protobuf {}", (Object)input);
                this.atlas = this.loadPbf(dataSource2, country);
                intermediateAtlasHandler.accept(this.atlas);
            }
        } else {
            String directory = this.pathResolver.resolvePath(input, country);
            List<Resource> atlasResources = this.loadHelper.collectSourceFiles(directory, true, atlasFilter);
            if (atlasResources.size() > 0) {
                this.atlas = new AtlasResourceLoader().load(atlasResources);
            } else {
                List<Resource> pbfResources = this.loadHelper.collectSourceFiles(directory, true, pbfFilter);
                int pbfCount = pbfResources.size();
                if (pbfCount > 0) {
                    this.logger.info("Loading Atlas from {} OSM protobuf(s) found in {}", (Object)pbfCount, (Object)input);
                    List<Atlas> atlases = pbfResources.parallelStream().map(dataSource -> this.loadPbf((Resource)dataSource, country)).peek(intermediateAtlasHandler).collect(Collectors.toList());
                    this.atlas = new MultiAtlas(atlases);
                }
            }
        }
        return this.atlas;
    }

    public void setAtlas(Atlas atlas) {
        this.atlas = atlas;
    }

    private Atlas loadPbf(Resource input, String country) {
        CountryBoundaryMap map = CountryBoundaryMap.fromBoundaryMap(Collections.singletonMap(country, this.polygon));
        AtlasLoadingOption option = AtlasLoadingOption.createOptionWithAllEnabled(map);
        Atlas raw = new RawAtlasGenerator(input, option, this.polygon).build();
        return new WaySectionProcessor(raw, option).run();
    }
}

