/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.clean;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryMapper;

public class HoleRemover {
    private Geometry geom;
    private Predicate isRemoved;

    public HoleRemover(Geometry geom, Predicate isRemoved) {
        this.geom = geom;
        this.isRemoved = isRemoved;
    }

    public Geometry getResult() {
        return GeometryMapper.map(this.geom, (GeometryMapper.MapOp)new HoleRemoverMapOp());
    }

    private static class PolygonHoleRemover {
        private Polygon poly;
        private Predicate isRemoved;

        public static Polygon clean(Polygon poly, Predicate isRemoved) {
            PolygonHoleRemover pihr = new PolygonHoleRemover(poly, isRemoved);
            return pihr.getResult();
        }

        public PolygonHoleRemover(Polygon poly, Predicate isRemoved) {
            this.poly = poly;
            this.isRemoved = isRemoved;
        }

        public Polygon getResult() {
            GeometryFactory gf = this.poly.getFactory();
            Polygon shell = gf.createPolygon((LinearRing)this.poly.getExteriorRing());
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < this.poly.getNumInteriorRing(); ++i) {
                LinearRing hole = (LinearRing)this.poly.getInteriorRingN(i);
                if (this.isRemoved.value(hole)) continue;
                holes.add(hole);
            }
            if (holes.size() == this.poly.getNumInteriorRing()) {
                return this.poly;
            }
            Polygon result = gf.createPolygon((LinearRing)this.poly.getExteriorRing(), GeometryFactory.toLinearRingArray(holes));
            return result;
        }
    }

    private class HoleRemoverMapOp
    implements GeometryMapper.MapOp {
        private HoleRemoverMapOp() {
        }

        @Override
        public Geometry map(Geometry geom) {
            if (geom instanceof Polygon) {
                return PolygonHoleRemover.clean((Polygon)geom, HoleRemover.this.isRemoved);
            }
            return geom;
        }
    }

    public static interface Predicate {
        public boolean value(Geometry var1);
    }
}

