/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class BaseHandler
extends DefaultHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final EntityResolver entityResolver;

    BaseHandler(EntityResolver anEntityResolver) {
        this.entityResolver = anEntityResolver;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.entityResolver != null) {
            try {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
            catch (SAXException se) {
                throw se;
            }
            catch (IOException ioe) {
                throw new SAXException("I/O error has occurred - " + ioe, ioe);
            }
        }
        this.log.warn("ignoring publicId=" + publicId + " and systemId=" + systemId);
        return null;
    }

    public void warning(SAXParseException e) {
        this.log.warn("non-fatal error while parsing XML document", e);
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.entityResolver != null) {
            this.log.error("failed parsing XML resource in validating mode", e);
            throw e;
        }
        this.log.warn("ignoring parse error", e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.log.fatal("failed parsing XML resource", e);
        throw e;
    }
}

