/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class CircularArc {
    static final double EPS = 1.0E-12;
    public static final double COLLINEARS = Double.POSITIVE_INFINITY;
    private static final String BASE_SEGMENTS_QUADRANT_KEY = "org.getools.geometry.arc.baseSegmentsQuadrant";
    static int BASE_SEGMENTS_QUADRANT = Integer.valueOf(System.getProperty("org.getools.geometry.arc.baseSegmentsQuadrant", "12"));
    private static final String MAX_SEGMENTS_QUADRANT_KEY = "org.getools.geometry.arc.maxSegmentsQuadrant";
    static int MAX_SEGMENTS_QUADRANT = Integer.valueOf(System.getProperty("org.getools.geometry.arc.maxSegmentsQuadrant", "10000"));
    static final double HALF_PI = 1.5707963267948966;
    static final double TAU = Math.PI * 2;
    double[] controlPoints;
    double radius = Double.NaN;
    double centerX;
    double centerY;

    public static void setBaseSegmentsQuadrant(int baseSegmentsQuadrant) {
        if (baseSegmentsQuadrant < 0) {
            throw new IllegalArgumentException("The base segments per quadrant must be at least 1");
        }
        BASE_SEGMENTS_QUADRANT = baseSegmentsQuadrant;
    }

    public static void setMaxSegmentsQuadrant(int baseSegmentsQuadrant) {
        if (baseSegmentsQuadrant < 0) {
            throw new IllegalArgumentException("The max segments per quadrant must be at least 1");
        }
        MAX_SEGMENTS_QUADRANT = baseSegmentsQuadrant;
    }

    public CircularArc(double[] controlPoints) {
        if (controlPoints == null || controlPoints.length != 6) {
            throw new IllegalArgumentException("Invalid control point array, it must be made of 6 ordinates for a total of 3 control points, start, mid and end");
        }
        this.controlPoints = controlPoints;
    }

    public CircularArc(double sx, double sy, double mx, double my, double ex, double ey) {
        this(new double[]{sx, sy, mx, my, ex, ey});
    }

    public int getDimension() {
        return 2;
    }

    public double[] getControlPoints() {
        return this.controlPoints;
    }

    public double getRadius() {
        this.initializeCenterRadius();
        return this.radius;
    }

    public Coordinate getCenter() {
        this.initializeCenterRadius();
        if (this.radius == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Coordinate(this.centerX, this.centerY);
    }

    public double[] linearize(double tolerance) {
        this.initializeCenterRadius();
        if (this.radius == Double.POSITIVE_INFINITY || this.radius == 0.0) {
            return this.controlPoints;
        }
        return this.linearize(tolerance, new GrowableOrdinateArray()).getData();
    }

    GrowableOrdinateArray linearize(double tolerance, GrowableOrdinateArray array) {
        boolean clockwise;
        int segmentsPerQuadrant;
        this.initializeCenterRadius();
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("The tolerance must be a positive number (or zero, to make the system use the max number of segments per quadrant configured in org.getools.geometry.arc.maxSegmentsQuadrant, default is 10000)");
        }
        if (tolerance == 0.0) {
            segmentsPerQuadrant = MAX_SEGMENTS_QUADRANT;
        } else if (tolerance == Double.MAX_VALUE) {
            segmentsPerQuadrant = BASE_SEGMENTS_QUADRANT;
        } else {
            segmentsPerQuadrant = BASE_SEGMENTS_QUADRANT;
            double currentTolerance = this.computeChordCircleDistance(segmentsPerQuadrant);
            if (currentTolerance < tolerance) {
                while (currentTolerance < tolerance && segmentsPerQuadrant > 1) {
                    currentTolerance = this.computeChordCircleDistance(segmentsPerQuadrant /= 2);
                }
                if (currentTolerance > tolerance) {
                    segmentsPerQuadrant *= 2;
                }
            } else {
                while (currentTolerance > tolerance && segmentsPerQuadrant < MAX_SEGMENTS_QUADRANT) {
                    currentTolerance = this.computeChordCircleDistance(segmentsPerQuadrant *= 2);
                }
            }
        }
        double sx = this.controlPoints[0];
        double sy = this.controlPoints[1];
        double mx = this.controlPoints[2];
        double my = this.controlPoints[3];
        double ex = this.controlPoints[4];
        double ey = this.controlPoints[5];
        double sa = Math.atan2(sy - this.centerY, sx - this.centerX);
        double ma = Math.atan2(my - this.centerY, mx - this.centerX);
        double ea = Math.atan2(ey - this.centerY, ex - this.centerX);
        double step = 1.5707963267948966 / (double)segmentsPerQuadrant;
        boolean bl = clockwise = sa > ma && ma > ea || sa > ma && sa < ea || ma > ea && sa < ea;
        if (clockwise) {
            double tx = sx;
            sx = ex;
            ex = tx;
            double ty = sy;
            sy = ey;
            ey = ty;
            double ta = sa;
            sa = ea;
            ea = ta;
        }
        if (ma < sa) {
            ma += Math.PI * 2;
            ea += Math.PI * 2;
        } else if (ea < sa) {
            ea += Math.PI * 2;
        }
        double angle = (Math.floor(sa / step) + 1.0) * step;
        if (angle > ea) {
            array.addAll(this.controlPoints);
            return array;
        }
        int points = 2 + (int)Math.ceil((ea - angle) / step);
        if (!this.isWhole((ma - angle) / step)) {
            ++points;
        }
        int start = array.size();
        array.ensureLength(start + points * 2);
        array.add(sx, sy);
        if (angle > ma) {
            array.add(mx, my);
            if (CircularArc.equals(angle, ma)) {
                angle += step;
            }
        }
        double end = ea - 1.0E-12;
        while (angle < end) {
            double x = this.centerX + this.radius * Math.cos(angle);
            double y = this.centerY + this.radius * Math.sin(angle);
            array.add(x, y);
            double next = angle + step;
            if (angle < ma && next > ma && !CircularArc.equals(angle, ma) && !CircularArc.equals(next, ma)) {
                array.add(mx, my);
            }
            angle = next;
        }
        array.add(ex, ey);
        if (clockwise) {
            array.reverseOrdinates(start, array.size() - 1);
        }
        return array;
    }

    private boolean isWhole(double d) {
        long num = (long)d;
        double fractional = d - (double)num;
        return fractional < 1.0E-12;
    }

    private double computeChordCircleDistance(int segmentsPerQuadrant) {
        double halfChordLength = this.radius * Math.sin(1.5707963267948966 / (double)segmentsPerQuadrant);
        double apothem = Math.sqrt(this.radius * this.radius - halfChordLength * halfChordLength);
        return this.radius - apothem;
    }

    private void initializeCenterRadius() {
        if (Double.isNaN(this.radius)) {
            double sx = this.controlPoints[0];
            double sy = this.controlPoints[1];
            double mx = this.controlPoints[2];
            double my = this.controlPoints[3];
            double ex = this.controlPoints[4];
            double ey = this.controlPoints[5];
            if (CircularArc.equals(sx, ex) && CircularArc.equals(sy, ey)) {
                this.centerX = sx + (mx - sx) / 2.0;
                this.centerY = sy + (my - sy) / 2.0;
                this.radius = Math.sqrt((this.centerX - sx) * (this.centerX - sx) + (this.centerY - sy) * (this.centerY - sy));
            } else {
                double temp = mx * mx + my * my;
                double bc = (sx * sx + sy * sy - temp) / 2.0;
                double cd2 = (temp - ex * ex - ey * ey) / 2.0;
                double determinate = (sx - mx) * (my - ey) - (mx - ex) * (sy - my);
                if (Math.abs(determinate) < 1.0E-12) {
                    this.radius = Double.POSITIVE_INFINITY;
                    return;
                }
                determinate = 1.0 / determinate;
                this.centerX = (bc * (my - ey) - cd2 * (sy - my)) * determinate;
                this.centerY = ((sx - mx) * cd2 - (mx - ex) * bc) * determinate;
                this.radius = Math.sqrt((this.centerX - sx) * (this.centerX - sx) + (this.centerY - sy) * (this.centerY - sy));
            }
        }
    }

    public String toString() {
        return "CircularArc[" + Arrays.toString(this.controlPoints) + "]";
    }

    void reset() {
        this.radius = Double.NaN;
    }

    static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-12;
    }

    public Envelope getEnvelope() {
        Envelope result = new Envelope();
        this.expandEnvelope(result);
        return result;
    }

    void expandEnvelope(Envelope envelope) {
        boolean clockwise;
        this.initializeCenterRadius();
        double sx = this.controlPoints[0];
        double sy = this.controlPoints[1];
        double mx = this.controlPoints[2];
        double my = this.controlPoints[3];
        double ex = this.controlPoints[4];
        double ey = this.controlPoints[5];
        envelope.expandToInclude(sx, sy);
        envelope.expandToInclude(ex, ey);
        if (this.radius == Double.POSITIVE_INFINITY) {
            return;
        }
        double sa = Math.atan2(sy - this.centerY, sx - this.centerX);
        double ma = Math.atan2(my - this.centerY, mx - this.centerX);
        double ea = Math.atan2(ey - this.centerY, ex - this.centerX);
        boolean bl = clockwise = sa > ma && ma > ea || sa < ma && sa > ea || ma < ea && sa > ea;
        if (clockwise) {
            double tx = sx;
            sx = ex;
            ex = tx;
            double ty = sy;
            sy = ey;
            ey = ty;
            double ta = sa;
            sa = ea;
            ea = ta;
        }
        if (ma <= sa) {
            ma += Math.PI * 2;
            ea += Math.PI * 2;
        } else if (ea <= sa) {
            ea += Math.PI * 2;
        }
        for (double angle = (Math.floor(sa / 1.5707963267948966) + 1.0) * 1.5707963267948966; angle < ea; angle += 1.5707963267948966) {
            double x = this.centerX + this.radius * Math.cos(angle);
            double y = this.centerY + this.radius * Math.sin(angle);
            envelope.expandToInclude(x, y);
        }
    }
}

