/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FunctionExpression;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.util.ProgressListener;

public abstract class ClassificationFunction
extends DefaultExpression
implements FunctionExpression {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    FunctionName name;
    List<Expression> params = new ArrayList<Expression>(2);
    Literal fallback;
    ProgressListener progress;

    public ClassificationFunction(FunctionName name) {
        this.name = name;
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    @Override
    public abstract Object evaluate(Object var1);

    @Override
    public void setFallbackValue(Literal fallback) {
        this.fallback = fallback;
    }

    @Override
    public Literal getFallbackValue() {
        return this.fallback;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public FunctionName getFunctionName() {
        return this.name;
    }

    @Override
    public List<Expression> getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(List<Expression> params) {
        this.params = params;
    }

    public ProgressListener getProgressListener() {
        return this.progress;
    }

    public void setProgressListener(ProgressListener progress) {
        this.progress = progress;
    }

    public int getNumberOfClasses() {
        return this.getClasses();
    }

    public int getClasses() {
        Literal classes = (Literal)this.getParameters().get(1);
        return classes.evaluate(null, Integer.class);
    }

    public void setNumberOfClasses(int classes) {
        this.setClasses(classes);
    }

    public void setClasses(int classes) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Literal expression = ff.literal(classes);
        this.getParameters().set(1, expression);
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    protected int decimalPlaces(double slotWidth) {
        String str = Double.toString(slotWidth);
        if (str.indexOf(".") > -1) {
            while (str.endsWith("0")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        int intPart = new Double(Math.floor(slotWidth)).intValue();
        double decPart = slotWidth - (double)intPart;
        int intPoints = Integer.toString(intPart).length();
        int decPoints = str.length() - intPoints;
        if (str.indexOf(".") > -1) {
            --decPoints;
        }
        if (decPart == 0.0) {
            decPoints = 0;
        }
        if (intPart == 0) {
            if (decPoints > 6) {
                return 5;
            }
            if (decPoints > 0) {
                return decPoints;
            }
            return 1;
        }
        if (decPoints == 0) {
            return 0;
        }
        int chars = intPoints + decPoints;
        if (chars < 6) {
            return decPoints;
        }
        if (intPoints > 4) {
            return 1;
        }
        return 5 - intPoints;
    }

    protected double round(double value, int decimalPlaces) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = (double)Math.round(newVal) / divisor;
        return newVal;
    }

    protected double fixRound(double value, int decimalPlaces, boolean up) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = up ? (newVal += 1.0) : (newVal -= 1.0);
        return newVal /= divisor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

