/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.names.NameTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class AbbreviatedNameCheck
extends BaseCheck<String> {
    private static final String ABBREVIATION_KEY = "abbreviations";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("OSM feature with id {0,number,#}'s name tag (`name` = **{1}**) has an abbreviation. Please update the `name` tag to not use abbreviation.");
    private static final Splitter NAME_SPLITTER = Splitter.on((CharMatcher)CharMatcher.JAVA_LETTER_OR_DIGIT.negate()).omitEmptyStrings();
    private static final long serialVersionUID = -3648610800112828238L;
    private final Set<String> abbreviations;

    public AbbreviatedNameCheck(Configuration configuration) {
        super(configuration);
        this.abbreviations = this.configurationValue(configuration, ABBREVIATION_KEY, new ArrayList(), Sets::newHashSet).stream().map(abbreviation -> abbreviation.toLowerCase(this.getLocale())).collect(Collectors.toSet());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof AtlasEntity && !this.isFlagged(this.getUniqueOSMIdentifier((AtlasObject)((AtlasEntity)object)));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(this.getUniqueOSMIdentifier((AtlasObject)((AtlasEntity)object)));
        Optional optionalName = NameTag.getNameOf((Taggable)object);
        if (!optionalName.isPresent()) {
            return Optional.empty();
        }
        String name = (String)optionalName.get();
        String lowercaseName = name.toLowerCase(this.getLocale());
        HashSet tokens = Sets.newHashSet((Iterable)NAME_SPLITTER.split((CharSequence)lowercaseName));
        if (tokens.stream().anyMatch(this.abbreviations::contains)) {
            CheckFlag flag = this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), name));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

