/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.validation.areas.AreasWithHighwayTagCheckWalker;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class AreasWithHighwayTagCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The way with OSM ID {0,number,#} has a highway value of {1}, which should not have an area=yes tag. Consider changing this to highway={2}.", "The way with OSM ID {0,number,#} has a highway value of {1}, which should not have an area=yes tag.");
    private static final long serialVersionUID = 3638306611072651348L;
    private static final EnumSet<HighwayTag> VALID_HIGHWAY_TAGS = EnumSet.of(HighwayTag.SERVICES, HighwayTag.SERVICE, HighwayTag.REST_AREA, HighwayTag.PEDESTRIAN, HighwayTag.PLATFORM);

    public AreasWithHighwayTagCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Area || object instanceof Edge && ((Edge)object).isMasterEdge()) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        return HighwayTag.highwayTag((Taggable)object).filter(tag -> AreasWithHighwayTagCheck.isUnacceptableAreaHighwayTagCombination(object, tag)).map(tag -> {
            Set<AtlasObject> results;
            String instruction = tag.equals((Object)HighwayTag.FOOTWAY) ? this.getLocalizedInstruction(0, object.getOsmIdentifier(), tag, HighwayTag.PEDESTRIAN) : this.getLocalizedInstruction(1, object.getOsmIdentifier(), tag.getTagValue());
            if (object instanceof Edge) {
                AreasWithHighwayTagCheckWalker walker = new AreasWithHighwayTagCheckWalker((Edge)object);
                Set<Edge> connectedBadEdges = walker.collectEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
                connectedBadEdges.forEach(badEdge -> this.markAsFlagged(badEdge.getOsmIdentifier()));
                results = new HashSet(connectedBadEdges);
            } else {
                results = Collections.singleton(object);
                this.markAsFlagged(object.getOsmIdentifier());
            }
            return this.createFlag(results, instruction);
        });
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    static boolean isUnacceptableAreaHighwayTagCombination(AtlasObject object, HighwayTag tag) {
        return !VALID_HIGHWAY_TAGS.contains(tag) && Validators.isOfType((Taggable)object, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES});
    }
}

