/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonObject;
import java.util.Map;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;

public class FlaggedPolyline
extends FlaggedObject {
    private static final long serialVersionUID = -1184306312148054279L;
    private final AtlasItem atlasItem;
    private final String country;
    private final PolyLine polyLine;
    private final Map<String, String> properties;

    public FlaggedPolyline(AtlasItem atlasItem) {
        this.atlasItem = atlasItem;
        this.polyLine = atlasItem instanceof Area ? new PolyLine(((Area)atlasItem).asPolygon().closedLoop()) : new PolyLine(atlasItem.getRawGeometry());
        this.properties = this.initProperties((AtlasObject)atlasItem);
        this.country = this.initCountry((AtlasObject)atlasItem);
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return this.polyLine;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public JsonObject asGeoJsonFeature(String flagIdentifier) {
        JsonObject feature = this.atlasItem.asGeoJsonGeometry();
        JsonObject properties = feature.getAsJsonObject("properties");
        properties.addProperty("flag:id", flagIdentifier);
        properties.addProperty("flag:type", FlaggedPolyline.class.getSimpleName());
        return feature;
    }

    @Override
    public Rectangle bounds() {
        return this.atlasItem.bounds();
    }

    private String initCountry(AtlasObject object) {
        Map tags = object.getTags();
        if (tags.containsKey("iso_country_code")) {
            return (String)tags.get("iso_country_code");
        }
        return "N/A";
    }

    private Map<String, String> initProperties(AtlasObject object) {
        Map tags = object.getTags();
        tags.put("ItemId", object.getIdentifier() + "");
        tags.put("osmid", object.getOsmIdentifier() + "");
        if (object instanceof Area) {
            tags.put("ItemType", "Area");
        } else if (object instanceof Line) {
            tags.put("ItemType", "Line");
        } else if (object instanceof Edge) {
            tags.put("ItemType", "Edge");
        } else if (object instanceof Node) {
            tags.put("ItemType", "Node");
        } else if (object instanceof Point) {
            tags.put("ItemType", "Point");
        }
        return tags;
    }
}

