/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlaggedPoint
extends FlaggedObject {
    private static final long serialVersionUID = -5912453173756416690L;
    private static final Logger logger = LoggerFactory.getLogger(FlaggedPoint.class);
    private final Location point;
    private final Map<String, String> properties;
    private final LocationItem locationItem;

    public FlaggedPoint(LocationItem locationItem) {
        this.locationItem = locationItem;
        this.point = locationItem.getLocation();
        this.properties = this.initProperties(locationItem);
    }

    public FlaggedPoint(Location point) {
        this.locationItem = null;
        this.point = point;
        this.properties = Collections.EMPTY_MAP;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return this.point;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public JsonObject asGeoJsonFeature(String flagIdentifier) {
        JsonObject properties;
        JsonObject feature;
        if (this.locationItem != null) {
            feature = this.locationItem.asGeoJsonGeometry();
            properties = feature.getAsJsonObject("properties");
        } else {
            properties = new JsonObject();
            feature = GeoJsonUtils.feature((JsonObject)this.point.asGeoJsonGeometry(), (JsonObject)properties);
        }
        properties.addProperty("flag:id", flagIdentifier);
        properties.addProperty("flag:type", FlaggedPoint.class.getSimpleName());
        return feature;
    }

    @Override
    public Rectangle bounds() {
        if (this.locationItem != null) {
            return this.locationItem.bounds();
        }
        return this.point.bounds();
    }

    private Map<String, String> initProperties(LocationItem locationItem) {
        Map tags = locationItem.getTags();
        tags.put("ItemId", locationItem.getIdentifier() + "");
        tags.put("osmid", locationItem.getOsmIdentifier() + "");
        if (locationItem instanceof Node) {
            tags.put("ItemType", "Node");
        } else if (locationItem instanceof Point) {
            tags.put("ItemType", "Point");
        } else {
            logger.warn("Flagged LocationItem with unknown item type {}", (Object)locationItem);
        }
        return tags;
    }
}

