/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openstreetmap.atlas.checks.event.Event;
import org.openstreetmap.atlas.checks.event.Processor;
import org.openstreetmap.atlas.checks.event.ShutdownEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventService {
    private static final Logger logger = LoggerFactory.getLogger(EventService.class);
    private static Map<String, EventService> serviceMap = new ConcurrentHashMap<String, EventService>();
    private final EventBus eventBus;
    private final Collection<Processor<?>> processors = new HashSet();
    private final AtomicBoolean completed = new AtomicBoolean();

    public static EventService get(String key) {
        serviceMap.putIfAbsent(key, new EventService());
        return serviceMap.get(key);
    }

    private EventService() {
        this.eventBus = new EventBus((exception, context) -> logger.warn("An exception is thrown in EventBus.", exception));
    }

    public void complete() {
        if (!this.completed.compareAndSet(false, true)) {
            logger.warn("EventService is already completed. Skipping completion.");
            return;
        }
        this.eventBus.post((Object)new ShutdownEvent());
        new HashSet(this.processors).forEach(this::unregister);
    }

    public <T extends Event> void post(T event) {
        if (event == null) {
            logger.warn("EventService received a null event. Skipping posting.");
            return;
        }
        if (this.completed.get()) {
            logger.warn("EventService is already completed. Skipping posting.");
            return;
        }
        this.eventBus.post(event);
    }

    public <T extends Event> void register(Processor<T> processor) {
        this.eventBus.register(processor);
        this.processors.add(processor);
    }

    public <T extends Event> void unregister(Processor<T> processor) {
        this.eventBus.unregister(processor);
        this.processors.remove(processor);
    }
}

