/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteCommand;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDeserializer;
import org.openstreetmap.atlas.checks.maproulette.serializer.TaskDeserializer;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteUploadCommand
extends MapRouletteCommand {
    private static final Command.Switch<File> INPUT_DIRECTORY = new Command.Switch("logfiles", "Path to folder containing log files to upload to MapRoulette.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> CONFIG_LOCATION = new Command.Switch("config", "Path to a file containing MapRoulette challenge configuration.", File::new, Command.Optionality.OPTIONAL, "config/configuration.json");
    private static final String PARAMETER_CHALLENGE = "challenge";
    private static final String LOG_EXTENSION = "log";
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteUploadCommand.class);
    private final Map<String, Challenge> checkNameChallengeMap = new HashMap<String, Challenge>();

    @Override
    protected void execute(CommandMap commandMap, MapRouletteConfiguration configuration) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Task.class, (Object)new TaskDeserializer(configuration.getProjectName())).create();
        Configuration instructions = this.loadConfiguration(commandMap);
        ((File)commandMap.get(INPUT_DIRECTORY)).listFilesRecursively().forEach(logFile -> {
            if (FilenameUtils.getExtension((String)logFile.getName()).equals(LOG_EXTENSION)) {
                try (BufferedReader reader = new BufferedReader(new FileReader(logFile.getPath()));){
                    reader.lines().forEach(line -> {
                        Task task = (Task)gson.fromJson(line, Task.class);
                        try {
                            this.addTask(this.getChallenge(task.getChallengeName(), instructions), task);
                        }
                        catch (UnsupportedEncodingException | URISyntaxException error) {
                            logger.error("Error thrown while adding task: ", (Throwable)error);
                        }
                    });
                    this.uploadTasks();
                }
                catch (IOException error) {
                    logger.error(MessageFormat.format("Error while reading {0}: ", logFile.getName()), (Throwable)error);
                }
            }
        });
    }

    private Configuration loadConfiguration(CommandMap map) {
        return new StandardConfiguration((Resource)((File)map.get(CONFIG_LOCATION)));
    }

    private String getChallengeParameter(String checkName) {
        return MessageFormat.format("{0}.{1}", checkName, PARAMETER_CHALLENGE);
    }

    private Challenge getChallenge(String checkName, Configuration fallbackConfiguration) {
        return this.checkNameChallengeMap.computeIfAbsent(checkName, name -> {
            Map challengeMap = (Map)fallbackConfiguration.get(this.getChallengeParameter(checkName), Collections.emptyMap()).value();
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Challenge.class, (Object)new ChallengeDeserializer()).create();
            Challenge result = (Challenge)gson.fromJson(gson.toJson((Object)challengeMap), Challenge.class);
            result.setName(checkName);
            return result;
        });
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(new Command.Switch[]{INPUT_DIRECTORY, CONFIG_LOCATION});
    }

    public static void main(String[] args) {
        new MapRouletteUploadCommand().run(args);
    }
}

