/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.base;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckResourceLoader {
    private static final String DEFAULT_ENABLED_KEY_TEMPLATE = "%s.enabled";
    private static final String DEFAULT_PACKAGE = "org.openstreetmap.atlas.checks";
    private static final String DEFAULT_TYPE = Check.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(CheckResourceLoader.class);
    private final Class<?> checkType;
    private final Configuration configuration;
    private final MultiMap<String, String> countryGroups = new MultiMap();
    private final Boolean enabledByDefault;
    private final String enabledKeyTemplate;
    private final Set<String> packages;
    private final Optional<List<String>> checkWhiteList;
    private final Optional<List<String>> checkBlackList;

    public CheckResourceLoader(Configuration configuration) {
        this.packages = Collections.unmodifiableSet(Iterables.asSet((Iterable)((Iterable)configuration.get("CheckResourceLoader.scanUrls", Collections.singletonList(DEFAULT_PACKAGE)).value())));
        Map groups = (Map)configuration.get("groups", Collections.emptyMap()).value();
        groups.keySet().forEach(group -> ((List)groups.get(group)).forEach(country -> this.countryGroups.add(country, group)));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            this.checkType = loader.loadClass((String)configuration.get("CheckResourceLoader.type", (Object)DEFAULT_TYPE).value());
        }
        catch (ClassNotFoundException classNotFound) {
            throw new CoreException("Unable to initialize CheckResourceLoader", (Throwable)classNotFound);
        }
        this.enabledByDefault = (Boolean)configuration.get("CheckResourceLoader.enabled.value.default", (Object)false).value();
        this.enabledKeyTemplate = (String)configuration.get("CheckResourceLoader.enabledKeyTemplate", (Object)DEFAULT_ENABLED_KEY_TEMPLATE).value();
        this.configuration = configuration;
        this.checkWhiteList = configuration.get("CheckResourceLoader.checks.whitelist").valueOption();
        this.checkBlackList = configuration.get("CheckResourceLoader.checks.blacklist").valueOption();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Configuration getConfigurationForCountry(String country) {
        Configuration specializedConfiguration = this.configuration.configurationForKeyword(country);
        List groups = this.countryGroups.get((Object)country);
        if (groups != null) {
            for (String group : groups) {
                specializedConfiguration = specializedConfiguration.configurationForKeyword(group);
            }
        }
        return specializedConfiguration;
    }

    public <T extends Check> Set<T> loadChecks(Predicate<Class> isEnabled) {
        return this.loadChecks(isEnabled, this.configuration);
    }

    public <T extends Check> Set<T> loadChecks(Configuration configuration) {
        return this.loadChecks(this::isEnabledByConfiguration, configuration);
    }

    public <T extends Check> Set<T> loadChecks(Predicate<Class> isEnabled, Configuration configuration) {
        HashSet checks = new HashSet();
        Time time = Time.now();
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
            this.packages.forEach(packageName -> classPath.getTopLevelClassesRecursive(packageName).forEach(classInfo -> {
                Class checkClass = classInfo.load();
                if (this.checkType.isAssignableFrom(checkClass) && !Modifier.isAbstract(checkClass.getModifiers()) && isEnabled.test(checkClass) && this.checkWhiteList.map(whitelist -> whitelist.contains(checkClass.getSimpleName())).orElse(true).booleanValue() && this.checkBlackList.map(blacklist -> !blacklist.contains(checkClass.getSimpleName())).orElse(true).booleanValue()) {
                    try {
                        Object check;
                        try {
                            check = checkClass.getConstructor(Configuration.class).newInstance(configuration);
                        }
                        catch (InvocationTargetException oops) {
                            throw new CoreException("Unable to create a configurable instance of {}", new Object[]{checkClass.getSimpleName(), oops});
                        }
                        catch (NoSuchMethodException oops) {
                            check = checkClass.newInstance();
                        }
                        if (check != null) {
                            checks.add((Check)check);
                        }
                    }
                    catch (ClassCastException | IllegalAccessException | InstantiationException oops) {
                        logger.error("Failed to instantiate {}, ignoring. Reason: {}", (Object)checkClass.getName(), (Object)oops.getMessage());
                    }
                }
            }));
        }
        catch (IOException oops) {
            throw new CoreException("Failed to discover {} classes on classpath", new Object[]{this.checkType.getSimpleName()});
        }
        logger.info("Loaded {} {} in {}", new Object[]{checks.size(), this.checkType.getSimpleName(), time.elapsedSince()});
        return checks;
    }

    public <T extends Check> Set<T> loadChecks() {
        return this.loadChecks(this::isEnabledByConfiguration, this.configuration);
    }

    public <T extends Check> Set<T> loadChecksForCountry(String country) {
        Configuration countryConfiguration = this.getConfigurationForCountry(country);
        return this.loadChecks(checkClass -> this.isEnabledByConfiguration(countryConfiguration, (Class)checkClass), countryConfiguration);
    }

    private boolean isEnabledByConfiguration(Class checkClass) {
        return this.isEnabledByConfiguration(this.configuration, checkClass);
    }

    private boolean isEnabledByConfiguration(Configuration configuration, Class checkClass) {
        String key = String.format(this.enabledKeyTemplate, checkClass.getSimpleName());
        return (Boolean)configuration.get(key, (Object)this.enabledByDefault).value();
    }
}

