/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.IntersectionUtilities;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OverlappingAOIPolygonCheck
extends BaseCheck {
    private static final long serialVersionUID = -3286838841854959683L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Area (id={0,number,#}) overlaps area (id={1,number,#}) and represent the same AOI.");
    private static final List<String> AOI_FILTERS_DEFAULT = Arrays.asList("amenity->FESTIVAL_GROUNDS", "amenity->GRAVE_YARD|landuse->CEMETERY", "boundary->NATIONAL_PARK,PROTECTED_AREA|leisure->NATURE_RESERVE,PARK", "historic->BATTLEFIELD", "landuse->FOREST|natural->WOOD", "landuse->RECREATION_GROUND|leisure->RECREATION_GROUND", "landuse->VILLAGE_GREEN|leisure->PARK", "leisure->GARDEN", "leisure->GOLF_COURSE|sport->GOLF", "leisure->PARK&name->*", "natural->BEACH", "tourism->ZOO");
    private static final double MINIMUM_PROPORTION_DEFAULT = 0.01;
    private final double minimumIntersect;
    private final List<TaggableFilter> aoiFilters = new ArrayList<TaggableFilter>();

    public OverlappingAOIPolygonCheck(Configuration configuration) {
        super(configuration);
        this.minimumIntersect = this.configurationValue(configuration, "intersect.minimum.limit", 0.01);
        List<String> aoiFiltersString = this.configurationValue(configuration, "aoi.tags.filters", AOI_FILTERS_DEFAULT);
        aoiFiltersString.forEach(string -> this.aoiFilters.add(TaggableFilter.forDefinition((String)string)));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && !this.isFlagged(object.getIdentifier()) && this.aoiFiltersTest(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area aoi = (Area)object;
        Polygon aoiPolygon = aoi.asPolygon();
        Rectangle aoiBounds = aoiPolygon.bounds();
        boolean hasOverlap = false;
        Set overlappingAreas = Iterables.stream((Iterable)object.getAtlas().areasIntersecting((Polygon)aoiBounds, area -> area.getIdentifier() != aoi.getIdentifier() && !this.isFlagged(area.getIdentifier()) && area.intersects((GeometricSurface)aoiPolygon) && this.aoiFiltersTest((AtlasObject)area))).collectToSet();
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier(object));
        flag.addObject(object);
        for (Area area2 : overlappingAreas) {
            if (!(IntersectionUtilities.findIntersectionPercentage(aoiPolygon, area2.asPolygon()) >= this.minimumIntersect) || !this.aoiFiltersTest(object, area2)) continue;
            flag.addObject((AtlasObject)area2);
            flag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier(), area2.getOsmIdentifier()));
            this.markAsFlagged(area2.getIdentifier());
            hasOverlap = true;
        }
        if (hasOverlap) {
            this.markAsFlagged(object.getIdentifier());
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean aoiFiltersTest(AtlasObject object) {
        return this.aoiFilters.stream().anyMatch(filter -> filter.test((Taggable)object));
    }

    private boolean aoiFiltersTest(AtlasObject object, Area area) {
        return this.aoiFilters.stream().anyMatch(filter -> filter.test((Taggable)object) && filter.test((Taggable)area));
    }
}

