/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation;

import com.vividsolutions.jts.geom.LineString;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;

public final class GeometryValidator {
    private static final JtsPolyLineConverter POLYLINE_CONVERTER = new JtsPolyLineConverter();
    private static final JtsPolygonConverter POLYGON_CONVERTER = new JtsPolygonConverter();

    public static boolean isValidPolygon(Polygon polygon) {
        com.vividsolutions.jts.geom.Polygon jtsPolygon = POLYGON_CONVERTER.convert(polygon);
        return jtsPolygon.isSimple();
    }

    public static boolean isValidPolyLine(PolyLine polyline) {
        LineString lineString = POLYLINE_CONVERTER.convert(polyline);
        return lineString.isSimple();
    }

    private GeometryValidator() {
    }
}

