/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import java.util.Collections;
import java.util.Map;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlaggedPoint
extends FlaggedObject {
    private static final long serialVersionUID = -5912453173756416690L;
    private static final Logger logger = LoggerFactory.getLogger(FlaggedPoint.class);
    private final Location point;
    private final Map<String, String> properties;

    public FlaggedPoint(LocationItem locationItem) {
        this.point = locationItem.getLocation();
        this.properties = this.initProperties(locationItem);
    }

    public FlaggedPoint(Location point) {
        this.point = point;
        this.properties = Collections.EMPTY_MAP;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return this.point;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    private Map<String, String> initProperties(LocationItem locationItem) {
        Map tags = locationItem.getTags();
        tags.put("ItemId", locationItem.getIdentifier() + "");
        tags.put("osmid", locationItem.getOsmIdentifier() + "");
        if (locationItem instanceof Node) {
            tags.put("ItemType", "Node");
        } else if (locationItem instanceof Point) {
            tags.put("ItemType", "Point");
        } else {
            logger.warn("Flagged LocationItem with unknown item type {}", (Object)locationItem);
        }
        return tags;
    }
}

