/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationMemberElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationMemberListener;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagListener;
import org.xml.sax.Attributes;

public class RelationElementProcessor
extends EntityElementProcessor
implements TagListener,
RelationMemberListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_MEMBER = "member";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private TagElementProcessor tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    private RelationMemberElementProcessor relationMemberElementProcessor = new RelationMemberElementProcessor((BaseElementProcessor)this, this);
    private Relation relation;

    public RelationElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing) {
        super(parentProcessor, sink, enableDateParsing);
    }

    @Override
    public void begin(Attributes attributes) {
        long id = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String sversion = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (sversion == null) {
            throw new OsmosisRuntimeException("Relation " + id + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int version = Integer.parseInt(sversion);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String rawUserId = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String rawUserName = attributes.getValue(ATTRIBUTE_NAME_USER);
        long changesetId = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        OsmUser user = this.buildUser(rawUserId, rawUserName);
        this.relation = new Relation(new CommonEntityData(id, version, timestampContainer, user, changesetId));
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_MEMBER.equals(qName)) {
            return this.relationMemberElementProcessor;
        }
        if (ELEMENT_NAME_TAG.equals(qName)) {
            return this.tagElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
        this.getSink().process(new RelationContainer(this.relation));
    }

    @Override
    public void processTag(Tag tag) {
        this.relation.getTags().add(tag);
    }

    @Override
    public void processRelationMember(RelationMember relationMember) {
        this.relation.getMembers().add(relationMember);
    }
}

