/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.util.Date;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.time.DateFormatter;
import org.openstreetmap.osmosis.core.time.DateParser;

public class XmlTimestampFormat
extends TimestampFormat {
    private ThreadLocal<DateFormatter> dateFormatterStore = new ThreadLocal();
    private ThreadLocal<DateParser> dateParserStore = new ThreadLocal();

    @Override
    public String formatTimestamp(Date timestamp) {
        DateFormatter dateFormatter = this.dateFormatterStore.get();
        if (dateFormatter == null) {
            dateFormatter = new DateFormatter();
            this.dateFormatterStore.set(dateFormatter);
        }
        return dateFormatter.format(timestamp);
    }

    @Override
    public Date parseTimestamp(String timestamp) {
        DateParser dateParser = this.dateParserStore.get();
        if (dateParser == null) {
            dateParser = new DateParser();
            this.dateParserStore.set(dateParser);
        }
        return dateParser.parse(timestamp);
    }
}

