/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.xml.common.CompressionActivator;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;

public abstract class BaseXmlWriter {
    private static Logger log = Logger.getLogger(BaseXmlWriter.class.getName());
    private boolean closeRequired;
    private boolean writerProvided;
    private File file;
    private boolean initialized;
    private BufferedWriter writer;
    private CompressionMethod compressionMethod;

    public BaseXmlWriter(BufferedWriter writer) {
        this.writer = writer;
        this.writerProvided = true;
        this.closeRequired = false;
    }

    public BaseXmlWriter(File file, CompressionMethod compressionMethod) {
        this.file = file;
        this.compressionMethod = compressionMethod;
        this.writerProvided = false;
        this.closeRequired = true;
    }

    protected abstract void setWriterOnElementWriter(BufferedWriter var1);

    protected abstract void beginElementWriter();

    protected abstract void endElementWriter();

    private void write(String data) {
        try {
            this.writer.write(data);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", e);
        }
    }

    private void writeNewLine() {
        try {
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", e);
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    protected void initialize() {
        if (!this.initialized) {
            if (!this.writerProvided) {
                OutputStream outStream = null;
                try {
                    if (this.file.getName().equals("-")) {
                        outStream = System.out;
                        this.closeRequired = false;
                    } else {
                        outStream = new FileOutputStream(this.file);
                    }
                    outStream = new CompressionActivator(this.compressionMethod).createCompressionOutputStream(outStream);
                    OutputStreamWriter outStreamWriter = new OutputStreamWriter(outStream, "UTF-8");
                    this.writer = new BufferedWriter(outStreamWriter);
                    outStream = null;
                }
                catch (IOException e) {
                    throw new OsmosisRuntimeException("Unable to open file for writing.", e);
                }
                finally {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Unable to close output stream.", e);
                        }
                        outStream = null;
                    }
                }
            }
            this.setWriterOnElementWriter(this.writer);
            this.initialized = true;
            this.write("<?xml version='1.0' encoding='UTF-8'?>");
            this.writeNewLine();
            this.beginElementWriter();
        }
    }

    public void complete() {
        this.initialize();
        this.endElementWriter();
        try {
            if (this.closeRequired) {
                this.writer.close();
                this.writer = null;
            } else if (!this.writerProvided) {
                this.writer.flush();
            }
            this.initialized = false;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to complete writing to the xml stream.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block9: {
            try {
                if (!this.closeRequired) break block9;
                try {
                    try {
                        if (this.writer != null) {
                            this.writer.close();
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Unable to close writer.", e);
                    }
                }
                finally {
                    this.writer = null;
                }
            }
            finally {
                this.initialized = false;
            }
        }
    }
}

