/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.unicode;

import java.nio.file.Path;
import org.openstreetmap.atlas.streaming.resource.ClassResource;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.LineFilteredResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.unicode.AbstractClassifier;
import org.openstreetmap.atlas.utilities.unicode.Classification;

public class LoadingClassifier
extends AbstractClassifier {
    private static final int START_INDEX = 0;
    private static final int END_INDEX = 1;
    private static final int CLASSIFICATION_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private final Resource resource;

    public LoadingClassifier() {
        this("org/openstreetmap/atlas/utilities/unicode/unicode.defaults");
    }

    public LoadingClassifier(Path path) {
        this(new File(path.toFile()));
    }

    public LoadingClassifier(Resource resource) {
        this.resource = resource;
        this.initialize();
    }

    public LoadingClassifier(String classResource) {
        this(new ClassResource(classResource));
    }

    @Override
    protected LoadingClassifier initialize() {
        if (this.resource != null) {
            Iterables.stream(new LineFilteredResource(this.resource, line -> !line.contains("IGNORE")).lines()).map(line -> StringList.split(line, ",")).forEach(list -> this.add(list.get(3), Integer.decode(list.get(0)), Integer.decode(list.get(1)), Classification.CodeBlock.valueOf(list.get(2).toUpperCase())));
            Iterables.stream(new LineFilteredResource(this.resource, line -> line.contains("IGNORE")).lines()).map(line -> StringList.split(line, ",")).forEach(list -> this.ignore(list.get(3), Integer.decode(list.get(0)), Integer.decode(list.get(1))));
        }
        return this;
    }
}

