/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.tuples;

import java.io.Serializable;

public class Tuple<A, B>
implements Serializable {
    private static final long serialVersionUID = 7745080808877729817L;
    private final A first;
    private final B second;

    public static <A, B> Tuple<A, B> cast(Tuple<?, ?> tuple, Class<A> aClass, Class<B> bClass) {
        if (tuple.isInstanceOf(aClass, bClass)) {
            return tuple;
        }
        throw new ClassCastException("Unable to cast, class mismatch");
    }

    public static <A, B> Tuple<A, B> createTuple(A first, B second) {
        return new Tuple<A, B>(first, second);
    }

    public Tuple(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)other;
        if (this.first == null ? tuple.first != null : !this.first.equals(tuple.first)) {
            return false;
        }
        return !(this.second == null ? tuple.second != null : !this.second.equals(tuple.second));
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean isInstanceOf(Class<?> classA, Class<?> classB) {
        return classA.isInstance(this.first) && classB.isInstance(this.second);
    }

    public String toString() {
        return String.format("(%s,%s)", this.first, this.second);
    }
}

