/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.threads;

import java.io.Closeable;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Ticker
implements Runnable,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Ticker.class);
    private static final Duration CHECK_TIME = Duration.milliseconds(500L);
    private final String name;
    private final Duration tickerTime;
    private volatile boolean stop;

    public Ticker(String name, Duration tickerTime) {
        this.name = name;
        this.tickerTime = tickerTime;
        this.stop = false;
    }

    @Override
    public void close() {
        this.stop = true;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        Time start = Time.now();
        Time lastCheck = Time.now();
        while (!this.stop) {
            CHECK_TIME.lowest(this.tickerTime).sleep();
            if (!lastCheck.elapsedSince().isMoreThan(this.tickerTime)) continue;
            try {
                this.tickAction(start.elapsedSince());
            }
            catch (Exception e) {
                logger.error("{} tick action failed! Associated job should not be affected.", (Object)this.getName(), (Object)e);
            }
            lastCheck = Time.now();
        }
    }

    public String toString() {
        return "Ticker [name=" + this.name + ", tickerTime=" + this.tickerTime + "]";
    }

    protected abstract void tickAction(Duration var1);
}

