/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.threads;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.CustomNamesThreadPoolFactory;
import org.openstreetmap.atlas.utilities.threads.Result;
import org.openstreetmap.atlas.utilities.threads.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pool
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Pool.class);
    private final ExecutorService pool;
    private final String name;
    private final int numberOfThreads;
    private final Duration endTimeout;
    private final Vector<Throwable> errors;

    public Pool(int numberOfThreads, String name) {
        this(numberOfThreads, name, Duration.ONE_DAY);
    }

    public Pool(int numberOfThreads, String name, Duration endTimeout) {
        this.numberOfThreads = numberOfThreads;
        this.name = name;
        this.endTimeout = endTimeout;
        this.errors = new Vector();
        this.pool = new FixedThreadPoolExecutor();
    }

    @Override
    public void close() {
        this.end(this.endTimeout);
    }

    public void end(Duration maxDuration) {
        if (!this.stop(maxDuration)) {
            logger.warn("Thread pool {} has ended before it was terminated (maxDuration = {}).", (Object)this.getName(), (Object)maxDuration);
        }
        if (!this.errors.isEmpty()) {
            this.errors.forEach(error -> logger.error("Unhandled error in {}!", (Object)this.name, error));
            throw new CoreException("{} tasks in {} had uncaught errors!", this.errors.size(), this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDead() {
        return this.pool.isTerminated() || this.pool.isShutdown();
    }

    public <T> Result<T> queue(Callable<T> task) {
        return new Result<T>(this.pool.submit(task), this);
    }

    public <T, V> V queue(Callable<T> task, Function<T, V> doWithTheOutput, Duration timeout) throws TimeoutException {
        Result<T> result = this.queue(task);
        T item = result.get(timeout);
        return doWithTheOutput.apply(item);
    }

    public <T> Result<T> queue(Callable<T> task, Ticker ticker) {
        Callable<Object> taskWrapper = () -> {
            try {
                Object v = task.call();
                return v;
            }
            finally {
                ticker.close();
            }
        };
        this.queue(ticker);
        return new Result<Object>(this.pool.submit(taskWrapper), this, ticker);
    }

    public void queue(Runnable command) {
        this.pool.execute(command);
    }

    public void queue(Runnable command, Ticker ticker) {
        Runnable commandWrapper = () -> {
            try {
                command.run();
            }
            finally {
                ticker.close();
            }
        };
        this.pool.execute(ticker);
        this.pool.execute(commandWrapper);
    }

    public <T> List<Result<T>> queueAll(Iterable<Callable<T>> tasks) {
        try {
            List<Future<T>> results = this.pool.invokeAll(Iterables.asList(tasks));
            return results.stream().flatMap(future -> Stream.of(new Result(future, this))).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new CoreException("Could not submit multiple Callables to {}", (Throwable)e, this.name);
        }
    }

    public <T, V> List<V> queueAll(Iterable<Callable<T>> tasks, Function<T, V> doWithTheOutput, Duration timeoutForEach) {
        ArrayList result = new ArrayList();
        List<Result<Result>> output = this.queueAll(tasks);
        output.forEach(futureResult -> {
            try {
                Object input = futureResult.get(timeoutForEach);
                Object out = doWithTheOutput.apply(input);
                result.add(out);
            }
            catch (TimeoutException e) {
                logger.warn("Timed out on {}", futureResult);
            }
        });
        return result;
    }

    public void queueCommands(Iterable<Runnable> commands) {
        commands.forEach(command -> this.queue((Runnable)command));
    }

    public boolean stop(Duration waitBeforeKill) {
        this.pool.shutdown();
        try {
            return this.pool.awaitTermination(waitBeforeKill.asMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Was interrupted. Could not stop {} within {}.", new Object[]{this.name, waitBeforeKill, e});
            return false;
        }
    }

    public String toString() {
        return "[Pool: " + this.getName() + ", " + this.numberOfThreads + " threads]";
    }

    private class FixedThreadPoolExecutor
    extends ThreadPoolExecutor {
        FixedThreadPoolExecutor() {
            super(Pool.this.numberOfThreads, Pool.this.numberOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new CustomNamesThreadPoolFactory(Pool.this.name));
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable oops) {
            if (oops != null) {
                Pool.this.errors.add(oops);
            }
        }
    }
}

