/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.testing;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.testing.Bean;
import org.openstreetmap.atlas.utilities.testing.BeanHandler;
import org.openstreetmap.atlas.utilities.testing.CreationContext;
import org.openstreetmap.atlas.utilities.testing.FieldHandler;
import org.openstreetmap.atlas.utilities.testing.TestAtlas;
import org.openstreetmap.atlas.utilities.testing.TestAtlasHandler;

public class CoreTestRule
implements TestRule {
    private static final SortedMap<Class<? extends Annotation>, FieldHandler> supportedAnnotations;
    private static final List<Class<? extends Annotation>> annotationLookup;

    @Override
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                List fields = CoreTestRule.this.findAllFieldsIn(CoreTestRule.this.getClass(), new ArrayList());
                Collections.sort(fields, new FieldComparator());
                try {
                    CreationContextImpl context = new CreationContextImpl();
                    for (Field field : fields) {
                        for (Annotation annotation : field.getAnnotations()) {
                            FieldHandler handler = (FieldHandler)supportedAnnotations.get(annotation.annotationType());
                            if (handler == null || !handler.handles(field)) continue;
                            handler.create(field, CoreTestRule.this, context);
                        }
                    }
                }
                catch (Throwable oops) {
                    throw new CoreException("Error when processing fields in test code annotations", oops);
                }
                base.evaluate();
            }
        };
    }

    private boolean filter(Field field) {
        return FieldComparator.sortValueFor(field) < Integer.MAX_VALUE;
    }

    private List<Field> findAllFieldsIn(Class<? extends CoreTestRule> klass, List<Field> fields) {
        for (Field field : klass.getDeclaredFields()) {
            if (!this.filter(field)) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        if (CoreTestRule.class.isAssignableFrom(klass.getSuperclass())) {
            this.findAllFieldsIn(klass.getSuperclass(), fields);
        }
        return fields;
    }

    static {
        List<Class> temporaryLookupTable = Arrays.asList(TestAtlas.class, Bean.class);
        annotationLookup = Collections.unmodifiableList(temporaryLookupTable);
        TreeMap<Class<Annotation>, FieldHandler> temp = new TreeMap<Class<Annotation>, FieldHandler>(new AnnotationClassComparator());
        temp.put(TestAtlas.class, new TestAtlasHandler());
        temp.put(Bean.class, new BeanHandler());
        supportedAnnotations = Collections.unmodifiableSortedMap(temp);
    }

    static class FieldComparator
    implements Comparator<Field> {
        FieldComparator() {
        }

        public static final int sortValueFor(Field field) {
            int currentValue = Integer.MAX_VALUE;
            for (Annotation current : field.getAnnotations()) {
                currentValue = Math.min(currentValue, AnnotationComparator.sortValueFor(current));
            }
            return currentValue;
        }

        @Override
        public int compare(Field first, Field second) {
            return FieldComparator.sortValueFor(first) - FieldComparator.sortValueFor(second);
        }
    }

    static class CreationContextImpl
    implements CreationContext {
        private final Table<String, Class<?>, Object> values = HashBasedTable.create();

        CreationContextImpl() {
        }

        @Override
        public <T> T get(String name, Class<T> klass) {
            Object val = this.values.get(name, klass);
            if (val != null) {
                return klass.cast(val);
            }
            return null;
        }

        @Override
        public <T> void set(String name, Class<T> klass, T object) {
            this.values.put(name, klass, object);
        }
    }

    static class AnnotationComparator
    implements Comparator<Annotation> {
        AnnotationComparator() {
        }

        public static final int sortValueFor(Annotation annotation) {
            return AnnotationClassComparator.sortValueFor(annotation.annotationType());
        }

        @Override
        public int compare(Annotation first, Annotation second) {
            return AnnotationComparator.sortValueFor(first) - AnnotationComparator.sortValueFor(second);
        }
    }

    static class AnnotationClassComparator
    implements Comparator<Class<? extends Annotation>> {
        AnnotationClassComparator() {
        }

        public static final int sortValueFor(Class<? extends Annotation> klass) {
            int returnValue = annotationLookup.indexOf(klass);
            return returnValue > -1 ? returnValue : Integer.MAX_VALUE;
        }

        @Override
        public int compare(Class<? extends Annotation> first, Class<? extends Annotation> second) {
            return AnnotationClassComparator.sortValueFor(first) - AnnotationClassComparator.sortValueFor(second);
        }
    }
}

