/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.openstreetmap.atlas.exception.CoreException;

public final class Ratio
implements Serializable {
    private static final long serialVersionUID = 8339825003035330715L;
    private static final double PERCENTAGE_PER_RATIO = 100.0;
    private static final double MAXIMUM_RATIO = 1.0;
    public static final Ratio MAXIMUM = Ratio.ratio(1.0);
    public static final Ratio MINIMUM = Ratio.ratio(0.0);
    public static final Ratio HALF = Ratio.ratio(0.5);
    private final double ratio;

    public static Ratio percentage(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new CoreException("percentage {} is not between 0.0 and {} inclusive.", percentage, 100.0);
        }
        return new Ratio(percentage / 100.0);
    }

    public static Ratio ratio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new CoreException("ratio {} is not between 0.0 and 1.0 inclusive.", ratio);
        }
        return new Ratio(ratio);
    }

    private Ratio(double ratio) {
        this.ratio = ratio;
    }

    public double asPercentage() {
        return this.ratio * 100.0;
    }

    public double asRatio() {
        return this.ratio;
    }

    public boolean equals(Object other) {
        if (other instanceof Ratio) {
            Ratio that = (Ratio)other;
            return this.asRatio() == that.asRatio();
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.ratio).hashCode();
    }

    public boolean isGreaterThan(Ratio that) {
        return this.asRatio() > that.asRatio();
    }

    public boolean isGreaterThanOrEqualTo(Ratio that) {
        return this.asRatio() >= that.asRatio();
    }

    public boolean isLessThan(Ratio that) {
        return this.asRatio() < that.asRatio();
    }

    public boolean isLessThanOrEqualTo(Ratio that) {
        return this.asRatio() <= that.asRatio();
    }

    public String toString() {
        return new DecimalFormat("#.##").format(this.asPercentage()) + " %";
    }

    public String toString(int decimalPlaces) {
        if (decimalPlaces > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("#.");
            for (int i = 0; i < decimalPlaces; ++i) {
                builder.append("#");
            }
            return new DecimalFormat(builder.toString()).format(this.asPercentage()) + " %";
        }
        return String.valueOf(this.asPercentage());
    }
}

