/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.Optional;
import org.openstreetmap.atlas.utilities.runtime.RunScriptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleLineMonitor
extends RunScriptMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SingleLineMonitor.class);
    private Optional<String> result = Optional.empty();

    public Optional<String> getResult() {
        return this.result;
    }

    protected abstract Optional<String> parseResult(String var1);

    @Override
    protected void parseStandardError(Iterable<String> lines) {
        this.parseStandardStream(lines);
    }

    @Override
    protected void parseStandardOutput(Iterable<String> lines) {
        this.parseStandardStream(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStandardStream(Iterable<String> lines) {
        for (String line : lines) {
            Optional<String> resultOption;
            if (this.result.isPresent() || !(resultOption = this.parseResult(line)).isPresent()) continue;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (!this.result.isPresent()) {
                    this.result = resultOption;
                    logger.trace("Found result: {}", (Object)resultOption.get());
                }
            }
        }
    }
}

