/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public class FlexibleCommand
extends Command {
    private FlexibleSubCommand subcommand;
    private Map<String, ? extends FlexibleSubCommand> commandMap;

    public static void main(String ... args) {
        if (args.length == 0) {
            new FlexibleCommand("FAILED").printUsageAndExit();
        }
        new FlexibleCommand(args[0]).run(args);
    }

    protected static boolean noAbstract(Class<? extends FlexibleSubCommand> klass) {
        return !Modifier.isAbstract(klass.getModifiers());
    }

    private static FlexibleSubCommand create(Class<? extends FlexibleSubCommand> klass) {
        try {
            return klass.newInstance();
        }
        catch (Exception oops) {
            throw new CoreException("Error when creating new instance of {}", klass.getCanonicalName(), oops);
        }
    }

    public FlexibleCommand(String ... args) {
        this.initializeCommands();
        if (args.length == 0) {
            this.printUsageAndExit();
        }
    }

    @Override
    public void run(String ... arguments) {
        String[] commandArgs = this.prepare(arguments);
        super.run(commandArgs);
    }

    @Override
    public void runWithoutQuitting(String ... arguments) {
        String[] commandArgs = this.prepare(arguments);
        super.runWithoutQuitting(commandArgs);
    }

    protected Stream<Class<? extends FlexibleSubCommand>> getSupportedCommands() {
        ArrayList returnValue = new ArrayList();
        new FastClasspathScanner(new String[0]).matchClassesImplementing(FlexibleSubCommand.class, returnValue::add).scan();
        return returnValue.stream();
    }

    @Override
    protected int onRun(CommandMap command) {
        return this.subcommand.execute(command);
    }

    protected void printUsageAndExit() {
        this.printUsageAndExit(-1);
    }

    protected void printUsageAndExit(int errorCode) {
        this.commandMap.entrySet().stream().forEach(item -> {
            System.err.printf("%s - %s\n", item.getKey(), ((FlexibleSubCommand)item.getValue()).getDescription());
            ((FlexibleSubCommand)item.getValue()).usage(System.err);
            System.err.printf("\n", new Object[0]);
        });
        System.exit(errorCode);
    }

    @Override
    protected Command.SwitchList switches() {
        return this.subcommand.switches();
    }

    private void initializeCommands() {
        this.commandMap = this.getSupportedCommands().filter(FlexibleCommand::noAbstract).map(FlexibleCommand::create).collect(Collectors.toMap(FlexibleSubCommand::getName, x -> x));
    }

    private String[] prepare(String ... arguments) {
        this.subcommand = this.commandMap.get(arguments[0]);
        if (this.subcommand == null) {
            this.printUsageAndExit();
        }
        String[] commandArgs = new String[arguments.length - 1];
        System.arraycopy(arguments, 1, commandArgs, 0, commandArgs.length);
        return commandArgs;
    }
}

