/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMapWithSet<K, V>
implements Map<K, Set<V>>,
Serializable {
    private static final long serialVersionUID = -8408806495092086637L;
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public void add(K key, V value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new HashSet());
        }
        this.map.get(key).add(value);
    }

    public List<V> allValues() {
        ArrayList<V> result = new ArrayList<V>();
        for (Set<V> valueList : this.values()) {
            result.addAll(valueList);
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MultiMapWithSet) {
            return this.map.equals(((MultiMapWithSet)other).map);
        }
        return false;
    }

    @Override
    public Set<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> map) {
        this.map.putAll(map);
    }

    @Override
    public void putAll(MultiMapWithSet<K, V> map) {
        this.putAll((Map<? extends K, ? extends Set<V>>)super.getMap());
    }

    @Override
    public Set<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.map.values();
    }

    private Map<K, Set<V>> getMap() {
        return this.map;
    }
}

