/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import java.util.Objects;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoLongToLongMultiMapAdapter;
import org.openstreetmap.atlas.utilities.arrays.Arrays;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.arrays.LongArrayOfArrays;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class LongToLongMultiMap
extends LargeMap<Long, long[]>
implements ProtoSerializable {
    private static final long serialVersionUID = 6741833447370296269L;

    public LongToLongMultiMap(long maximumSize) {
        super(maximumSize);
    }

    public LongToLongMultiMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public LongToLongMultiMap(String name, long maximumSize) {
        super(name, maximumSize);
    }

    public LongToLongMultiMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    private LongToLongMultiMap() {
    }

    public void add(Long key, long value) {
        long[] result = this.containsKey(key) ? Arrays.addNewItem((long[])this.get(key), value) : new long[]{value};
        this.put(key, result);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LongToLongMultiMap) {
            if (this == other) {
                return true;
            }
            LongToLongMultiMap that = (LongToLongMultiMap)other;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            Iterable iterable = () -> this.iterator();
            for (Long key : iterable) {
                long[] thatValue;
                if (!that.containsKey(key)) {
                    return false;
                }
                long[] thisValue = (long[])this.get(key);
                if (thisValue.length != (thatValue = (long[])that.get(key)).length) {
                    return false;
                }
                for (int index = 0; index < thisValue.length; ++index) {
                    if (thisValue[index] == thatValue[index]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoLongToLongMultiMapAdapter();
    }

    @Override
    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int nameHash = this.getName() == null ? 0 : this.getName().hashCode();
        int hash = 1147 + nameHash;
        hash = 37 * hash + Long.valueOf(this.size()).hashCode();
        Iterable iterable = () -> this.iterator();
        for (Long key : iterable) {
            long[] value = (long[])this.get(key);
            for (int index = 0; index < value.length; ++index) {
                hash = 37 * hash + Long.valueOf(value[index]).hashCode();
            }
        }
        return hash;
    }

    @Override
    protected String asValueString(long[] value) {
        StringList list = new StringList();
        for (long val : value) {
            list.add(val);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(list.join(", "));
        builder.append("]");
        return builder.toString();
    }

    @Override
    protected LargeArray<Long> createKeys(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<long[]> createValues(int memoryBlockSize, int subArraySize) {
        LongArrayOfArrays result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArrayOfArrays(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArrayOfArrays(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

