/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LinkedMultiMap<K, V>
implements Map<K, Set<V>>,
Serializable {
    private static final long serialVersionUID = 5668281262269816871L;
    private final Map<K, Set<V>> linkedMap = new LinkedHashMap<K, Set<V>>();

    public void add(K key, V value) {
        Set<V> values = this.linkedMap.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            this.linkedMap.put(key, values);
        }
        if (value != null) {
            values.add(value);
        }
    }

    @Override
    public void clear() {
        this.linkedMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.linkedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.linkedMap.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(value)).collect(Collectors.counting()) > 0L;
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.linkedMap.entrySet();
    }

    @Override
    public Set<V> get(Object key) {
        Set<V> values = this.linkedMap.get(key);
        return values == null ? Collections.EMPTY_SET : values;
    }

    @Override
    public boolean isEmpty() {
        return this.linkedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.linkedMap.keySet();
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this.linkedMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> map) {
        this.linkedMap.putAll(map);
    }

    @Override
    public Set<V> remove(Object key) {
        return this.linkedMap.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Set<V> values = this.linkedMap.get(key);
        if (values != null && values.contains(value)) {
            values.remove(value);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.linkedMap.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String entryDelimiter = "";
        builder.append("[");
        for (Map.Entry<K, Set<V>> entry : this.linkedMap.entrySet()) {
            K key = entry.getKey();
            Set<V> values = entry.getValue();
            builder.append(entryDelimiter);
            builder.append(key.toString());
            builder.append(" -> ");
            if (values != null && !values.isEmpty()) {
                Joiner.on(", ").skipNulls().appendTo(builder, (Iterable<?>)values);
            } else {
                builder.append("Empty values");
            }
            entryDelimiter = ", ";
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.linkedMap.values();
    }
}

