/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.conversion;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagConverter
implements StringConverter<Map<String, String>> {
    private static final Logger logger = LoggerFactory.getLogger(TagConverter.class);

    @Override
    public Map<String, String> convert(String tagsString) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (tagsString.length() > 1) {
            String[] pairs;
            for (String pair : pairs = tagsString.substring(1, tagsString.length() - 1).split("\", \\\"")) {
                String[] values = pair.split("=>");
                String key = values[0].substring(0, values[0].length() - 1);
                String value = values[1].substring(1, values[1].length());
                if (tags.containsKey(key)) {
                    logger.warn("Duplicate tags: {}", (Object)tagsString);
                    continue;
                }
                tags.put(key, value);
            }
        }
        return tags;
    }
}

