/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Joiner;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configurable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationDeserializer;
import org.openstreetmap.atlas.utilities.configuration.MergedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConfiguration
implements Configuration {
    private static final String OVERRIDE_STRING = "override";
    private static final Logger logger = LoggerFactory.getLogger(StandardConfiguration.class);
    private Map<String, Object> configurationData;
    private final String name;

    public StandardConfiguration(Resource resource) {
        this.name = resource.getName();
        try (InputStream read = resource.read();){
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, new ConfigurationDeserializer());
            objectMapper.registerModule(simpleModule);
            JsonParser parser = new JsonFactory().createParser(read);
            this.configurationData = objectMapper.readValue(parser, Map.class);
        }
        catch (Exception oops) {
            throw new CoreException("Failure to load configuration", oops);
        }
    }

    public StandardConfiguration(String name, Map<String, Object> configurationData) {
        this.name = name;
        this.configurationData = configurationData;
    }

    @Override
    public Set<String> configurationDataKeySet() {
        HashSet<String> keySet = new HashSet<String>(this.configurationData.keySet());
        return keySet;
    }

    @Override
    public Configuration configurationForKeyword(String keyword) {
        Optional<Map<String, Object>> overrideDataForKeyword = this.getOverrideDataForKeyword(keyword, this.configurationData);
        if (overrideDataForKeyword.isPresent()) {
            return new MergedConfiguration(new StandardConfiguration(this.name, overrideDataForKeyword.get()), this);
        }
        return this;
    }

    @Override
    public Configurable get(String key) {
        return new StandardConfigurable(key, null, Function.identity());
    }

    @Override
    public <Raw, Transformed> Configurable get(String key, Function<Raw, Transformed> transform) {
        return new StandardConfigurable(key, null, transform);
    }

    public Configurable get(String key, Object defaultValue) {
        return new StandardConfigurable(key, defaultValue, Function.identity());
    }

    @Override
    public <Raw, Transformed> Configurable get(String key, Raw defaultValue, Function<Raw, Transformed> transform) {
        return new StandardConfigurable(key, defaultValue, transform);
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    private Optional<Map<String, Object>> getOverrideDataForKeyword(String keyword, Map<String, Object> currentContext) {
        List<String> overrideKeyPrefixList = Arrays.asList(OVERRIDE_STRING, keyword);
        String overrideKeyPrefixString = Joiner.on(".").join(overrideKeyPrefixList);
        HashMap<String, Object> overrideData = new HashMap<String, Object>();
        for (String key : currentContext.keySet()) {
            if (key.equals(OVERRIDE_STRING)) continue;
            String overrideKey = Joiner.on(".").join(overrideKeyPrefixString, key, new Object[0]);
            Optional<Object> specificOverrideData = Optional.ofNullable(this.resolve(overrideKey, currentContext));
            if (specificOverrideData.isPresent()) {
                overrideData.put(key, specificOverrideData.get());
                continue;
            }
            Object nextContext = currentContext.get(key);
            if (!(nextContext instanceof Map)) continue;
            this.getOverrideDataForKeyword(keyword, (Map)nextContext).ifPresent(moreOverrideData -> overrideData.put(key, moreOverrideData));
        }
        return Optional.of(overrideData).filter(data -> !data.isEmpty());
    }

    private Object resolve(String key, Map<String, Object> currentContext) {
        if (StringUtils.isEmpty(key)) {
            return currentContext;
        }
        LinkedList<String> rootParts = new LinkedList<String>(Arrays.asList(key.split("\\.")));
        LinkedList<String> childParts = new LinkedList<String>();
        while (!rootParts.isEmpty()) {
            String currentKey = Joiner.on(".").join(rootParts);
            Object nextItem = currentContext.get(currentKey);
            if (nextItem instanceof Map) {
                String nextKey = Joiner.on(".").join(childParts);
                return this.resolve(nextKey, (Map)nextItem);
            }
            if (nextItem != null) {
                return nextItem;
            }
            childParts.addFirst(rootParts.removeLast());
        }
        return null;
    }

    private final class StandardConfigurable<Raw, Transformed>
    implements Configurable {
        private final Transformed defaultValue;
        private final String key;
        private final Function<Raw, Transformed> transform;

        private StandardConfigurable(String key, Raw defaultValue, Function<Raw, Transformed> transform) {
            this.key = key;
            this.transform = transform;
            this.defaultValue = Optional.ofNullable(defaultValue).map(transform).orElse(null);
        }

        @Override
        public <Type> Type value() {
            try {
                Object found = StandardConfiguration.this.resolve(this.key, StandardConfiguration.this.configurationData);
                return (Type)Optional.ofNullable(found).map(this.transform).orElse(this.defaultValue);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Invalid configuration type for %s", this.key), (Throwable)e);
                return null;
            }
        }

        @Override
        public <Type> Optional<Type> valueOption() {
            return Optional.ofNullable(this.value());
        }
    }
}

