/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.JoinedCollection;

public class ParallelIterable
implements Iterable<JoinedCollection> {
    private final List<Iterable> iterables;

    public ParallelIterable(Iterable ... iterables) {
        this.iterables = Arrays.asList(iterables);
    }

    public List<Iterator> getIteratorList() {
        ArrayList<Iterator> iteratorList = new ArrayList<Iterator>();
        this.iterables.forEach(iterator -> iteratorList.add(iterator.iterator()));
        return iteratorList;
    }

    @Override
    public Iterator<JoinedCollection> iterator() {
        return new Iterator<JoinedCollection>(){
            private final List<Iterator> iterators;
            {
                this.iterators = ParallelIterable.this.getIteratorList();
            }

            @Override
            public boolean hasNext() {
                return Iterables.filter(this.iterators, Iterator::hasNext).iterator().hasNext();
            }

            @Override
            public JoinedCollection next() {
                JoinedCollection joined = new JoinedCollection(this.iterators.size());
                for (int index = 0; index < this.iterators.size(); ++index) {
                    Iterator iterator = this.iterators.get(index);
                    if (!iterator.hasNext()) continue;
                    joined.set(index, iterator.next());
                }
                return joined;
            }
        };
    }
}

