/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.Iterator;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class MultiIterable<T>
implements Iterable<T> {
    private final Iterable<? extends Iterable<? extends T>> iterables;

    public MultiIterable(Iterable<? extends Iterable<? extends T>> iterables) {
        this.iterables = iterables;
    }

    @SafeVarargs
    public MultiIterable(Iterable<? extends T> ... iterables) {
        if (iterables.length == 0) {
            throw new CoreException("Cannot have an empty set of Iterables.");
        }
        this.iterables = Iterables.asList(iterables);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<? extends Iterable<? extends T>> iterablesIterator;
            private Iterator<? extends T> currentIterator;
            {
                this.iterablesIterator = MultiIterable.this.iterables.iterator();
                this.currentIterator = this.iterablesIterator.hasNext() ? this.iterablesIterator.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return true;
                }
                while (this.iterablesIterator.hasNext()) {
                    this.currentIterator = this.iterablesIterator.next().iterator();
                    if (this.currentIterator == null || !this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                return null;
            }
        };
    }
}

