/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching.strategies;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;

public abstract class AbstractCachingStrategy
implements CachingStrategy {
    private final Map<String, UUID> uriStringToUUIDCache = new HashMap<String, UUID>();

    @Override
    public abstract Optional<Resource> attemptFetch(URI var1, Function<URI, Resource> var2);

    @Override
    public abstract String getName();

    protected UUID getUUIDForResourceURI(URI resourceURI) {
        String uriString = resourceURI.toString();
        if (!this.uriStringToUUIDCache.containsKey(uriString)) {
            UUID newUUID = UUID.nameUUIDFromBytes(uriString.getBytes());
            this.uriStringToUUIDCache.put(uriString, newUUID);
            return newUUID;
        }
        return this.uriStringToUUIDCache.get(uriString);
    }
}

