/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching;

import java.nio.file.Paths;
import java.util.Optional;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.ByteArrayCachingStrategy;

public class LocalFileInMemoryCache
extends ConcurrentResourceCache {
    public LocalFileInMemoryCache() {
        super(new ByteArrayCachingStrategy(), uri -> new File(uri.getPath()));
    }

    @Override
    public Optional<Resource> get(String path) {
        return this.get(Paths.get(path, new String[0]).toAbsolutePath().toUri());
    }
}

